// GeoFigView.cpp : implementation of the CGeoFigView class
//

#include "stdafx.h"
#include "GeoFig.h"

#include "GeoFigDoc.h"
#include "GeoFigView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGeoFigView

IMPLEMENT_DYNCREATE(CGeoFigView, CView)

BEGIN_MESSAGE_MAP(CGeoFigView, CView)
	//{{AFX_MSG_MAP(CGeoFigView)
	ON_COMMAND(ID_FILE_RECTANGLE, OnFileRectangle)
	ON_COMMAND(ID_FILE_TRIANGLE, OnFileTriangle)
	ON_COMMAND(ID_FILE_CIRCLE, OnFileCircle)
	ON_COMMAND(ID_FIGURES_RECTANGLE, OnFiguresRectangle)
	ON_COMMAND(ID_FIGURES_CIRCLE, OnFiguresCircle)
	ON_COMMAND(ID_FIGURES_TRIANGLE, OnFiguresTriangle)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGeoFigView construction/destruction

CGeoFigView::CGeoFigView()
{
	// TODO: add construction code here

}

CGeoFigView::~CGeoFigView()
{
}

BOOL CGeoFigView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CGeoFigView drawing

void CGeoFigView::OnDraw(CDC* pDC)
{
	CGeoFigDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
	int xOrig = 10, 
		x = xOrig, y = 10,
		w = 30, h = 30,
		xOff = w + 20,
		yOff = h + 20,
		figsPerRow = 10;
	for ( int i = 0; i < pDoc->GetFigures().GetSize(); i++ ) {
	  CRect r( x, y, x + w, y + h );
	  pDoc->GetFigures()[ i ]->Draw( pDC, r );
      if ( 0 == ((i + 1) % figsPerRow) ) {
		x = xOrig;
	    y += yOff;
	  }
	  else
		x += xOff;
	}   
}

/////////////////////////////////////////////////////////////////////////////
// CGeoFigView printing

BOOL CGeoFigView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CGeoFigView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CGeoFigView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CGeoFigView diagnostics

#ifdef _DEBUG
void CGeoFigView::AssertValid() const
{
	CView::AssertValid();
}

void CGeoFigView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CGeoFigDoc* CGeoFigView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGeoFigDoc)));
	return (CGeoFigDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGeoFigView message handlers

void CGeoFigView::OnFileInstructions() 
{
	// TODO: Add your command handler code here
	CString msg =
		      CString( "Pick a figure from the menu\n" ) +
			  CString( "Then click where it is to be placed." );
	AfxMessageBox( msg );
}

void CGeoFigView::OnFileRectangle() 
{
	// TODO: Add your command handler code here
    GetDocument()->AddFigure( new CRectangle() );
}

void CGeoFigView::OnFileTriangle() 
{
	// TODO: Add your command handler code here
	GetDocument()->AddFigure( new CTriangle() );
}

void CGeoFigView::OnFileCircle() 
{
	// TODO: Add your command handler code here
	GetDocument()->AddFigure( new CCircle() );
}

void CGeoFigView::OnFiguresRectangle() 
{
	// TODO: Add your command handler code here
	OnFileRectangle();
}

void CGeoFigView::OnFiguresCircle() 
{
	// TODO: Add your command handler code here
	OnFileCircle();
}

void CGeoFigView::OnFiguresTriangle() 
{
	// TODO: Add your command handler code here
    OnFileTriangle();	
}
