#include "stdafx.h"

#ifndef CFigure_DEFINED
#include "Figure.h"
#endif

IMPLEMENT_SERIAL( CFigure, CObject, 1 )
IMPLEMENT_SERIAL( CRectangle, CFigure, 1 )
IMPLEMENT_SERIAL( CCircle, CFigure, 1 )
IMPLEMENT_SERIAL( CTriangle, CFigure, 1 )

CFigure::CFigure() { }

CFigure::~CFigure() { 
   brushPtr->DeleteObject();
   delete brushPtr;
}

void CFigure::Serialize( CArchive& ar ) { }
COLORREF CFigure::GetColor() { 
   return RGB( 0, 0, 0 ); // black
}

void CFigure::Draw( CDC* pDC, const CRect& r ) { }

CRectangle::CRectangle() { 
   brushPtr = new CBrush( GetColor() );
}

CRectangle::~CRectangle() { }

void CRectangle::Serialize( CArchive& ar ) { }
COLORREF CRectangle::GetColor() {
   return RGB( 255, 0 , 0 ); // red
}

void CRectangle::Draw( CDC* pDC, const CRect& r ) {
    pDC->SelectObject( brushPtr );
	pDC->Rectangle( r.TopLeft().x, r.TopLeft().y,
		            r.BottomRight().x, r.BottomRight().y );
}

CCircle::CCircle() {
   brushPtr = new CBrush( GetColor() ); 
}
CCircle::~CCircle() { }

void CCircle::Serialize( CArchive& ar ) { }

COLORREF CCircle::GetColor() {
	return RGB( 0, 255, 0 ); // green
}

void CCircle::Draw( CDC* pDC, const CRect& r ) {
	pDC->SelectObject( brushPtr );
	pDC->Ellipse( r.TopLeft().x, r.TopLeft().y,
		          r.BottomRight().x, r.BottomRight().y );
}

CTriangle::CTriangle() { 
   brushPtr = new CBrush( GetColor() );
}
CTriangle::~CTriangle() { }

void CTriangle::Serialize( CArchive& ar ) { }

COLORREF CTriangle::GetColor() {
   return RGB( 0, 0, 255 ); // blue
}

void CTriangle::Draw( CDC* pDC, const CRect& r ) {
	pDC->SelectObject( brushPtr );
	CPoint pts[ ] = { CPoint( r.TopLeft().x + r.Width() / 2, r.TopLeft().y ),
                      CPoint( r.TopLeft().x, r.TopLeft().y + r.Height() ),
				      CPoint( r.BottomRight().x, r.BottomRight().y ) };
    pDC->Polygon( pts, 3 );
}

