// dateCDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dateC.h"
#include "dateCDlg.h"
#include "DlgProxy.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDateCDlg dialog

IMPLEMENT_DYNAMIC(CDateCDlg, CDialog);

CDateCDlg::CDateCDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDateCDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDateCDlg)
	m_date = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pAutoProxy = NULL;
}

CDateCDlg::~CDateCDlg()
{
	// If there is an automation proxy for this dialog, set
	//  its back pointer to this dialog to NULL, so it knows
	//  the dialog has been deleted.
	if (m_pAutoProxy != NULL)
		m_pAutoProxy->m_pDialog = NULL;
}

void CDateCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDateCDlg)
	DDX_Text(pDX, IDC_EDIT1, m_date);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDateCDlg, CDialog)
	//{{AFX_MSG_MAP(CDateCDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDateCDlg message handlers

BOOL CDateCDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDateCDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDateCDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// Automation servers should not exit when a user closes the UI
//  if a controller still holds on to one of its objects.  These
//  message handlers make sure that if the proxy is still in use,
//  then the UI is hidden but the dialog remains around if it
//  is dismissed.

void CDateCDlg::OnClose() 
{
	if (CanExit())
		CDialog::OnClose();
}

void CDateCDlg::OnOK() 
{
	if (CanExit())
		CDialog::OnOK();
}

void CDateCDlg::OnCancel() 
{
	if (CanExit())
		CDialog::OnCancel();
}

BOOL CDateCDlg::CanExit()
{
	// If the proxy object is still around, then the automation
	//  controller is still holding on to this application.  Leave
	//  the dialog around, but hide its UI.
	if (m_pAutoProxy != NULL)
	{
		ShowWindow(SW_HIDE);
		return FALSE;
	}

	return TRUE;
}

//**** our callbacks for the two buttons that invoke the
//     methods exposed by the server
#include "dates.h" //*** jk: header for server
IDateS id;         //*** jk: interface class & object
bool dispatchExists = false; //*** jk: flag for internal use
//*** jk: ensure that IDispatch interface is
// released before the client (this) is destroyed
// ** Invoked from InitInstance in the application
// file (dateC.cpp) after the client dialog is closed;
// also invoked from OnButton2 below.
void CDateCDlg::checkRelease() {
   if ( dispatchExists ) {
     id.ReleaseDispatch();
     dispatchExists = false;
   }
}
//*** jk: callback for a click on the Show Calendar
// button. Create an IDispatch interface to the server
// and force the server's execution by invoking a method
// in that interface, namely, ShowCalendar(). Turn off
// "automatic" release of the interface, which forces
// the calendar to remain open so that the user can 
// specify a date.
void CDateCDlg::OnButton1() 
{
   // TODO: Add your control notification handler code here
   if ( !dispatchExists ) {
     id.CreateDispatch( "dateS.Application" );
     id.ShowCalendar();
     dispatchExists = true;
   }
}
//*** jk: callback for a click on the Get Date button.
// Get the date from the server by invoking the
// interface's GetDate method. Release the interface
// (hence, the server) and format the date to display
// in the client's text box.
// m_date is a data member that represents the client's
// text box
void CDateCDlg::OnButton2() 
{
   // TODO: Add your control notification handler code here
   if ( !dispatchExists ) //*** jk: server interface created?
     return;              //*** jk: if not, exit
   COleDateTime dt = id.GetDate(); // gets date from server
   checkRelease();                 // releases 
   m_date = dt.Format();      // from return type to CString
   //*** jk: false means "write from m_date to the text box"
   //        true means "read from text box into m_date"
   UpdateData( false ); //*** jk: forces data exchange   
}