#include <iostream>
using namespace std;

// copy from basic_istream to basic_ostream
template< class charT, class traits>
void copy( basic_istream<charT, traits>& in, 
           basic_ostream<charT, traits>& out ) {
   charT c;
   ios_base::iostate fl;
   // don't skip white space
   // save old flags in fl to restore at end
   fl = in.flags();
   in.unsetf( ios_base::skipws );
   while ( in >> c )
      out << c;
   // restore flags
   in.flags( fl );
}

