#include <stdio.h>
#include <stdlib.h>
#include <conc.h>

#define SIZE 10
#define RANGE 500

void selectsort( int *a, int size );
void swap( int *p, int *q );

main()
{
     Channel *in, *out;
     int i, a[ SIZE / 2 + 1 ], hostsize, childsize, *ptr;
     int inval, c;

     /* assign Channel pointers to physical channels */
     in =  LINK2IN;
     out = LINK2OUT;

     /* divide sorting problem in 2 parts */
     hostsize = SIZE / 2;
     childsize = SIZE - hostsize;

     /* get values for child to sort */
     for ( i = 0, ptr = a; i < childsize; i++ )
          *ptr++ = rand() % RANGE;

     /* send number of values and actual values to child */
     ChanOutInt( out, childsize );
     ChanOut( out, a, sizeof ( int ) * childsize );

     /* get own values to sort */
     for ( i = 0, ptr = a; i < hostsize; i++ )
          *ptr++ = rand() % RANGE;

     /* sort own values */
     selectsort( a, hostsize );

     /* merge child's and own values */
     ptr = a;
     c = i = 0;
     inval = ChanInInt( in );
     while ( i < hostsize )
          if ( inval < *ptr ) {
               printf( "%d\n", inval );
               if ( ++c < childsize )
                    inval = ChanInInt( in );
               else
                    break;
          }
          else {
               printf( "%d\n", *ptr++ );
               i++;
          }

     while ( c < childsize ) {
          printf( "%d\n", inval );
          if ( ++c < childsize )
               inval = ChanInInt( in );
     }

     while ( i < hostsize ) {
          printf( "%d\n", *ptr++ );
          i++;
     }
}

void selectsort( int *a, int size )
{
     int *end, *p, *small;

     end = a + size;

     for ( ; a < end - 1; a++ ) {
          small = a;
          for ( p = a + 1; p < end; p++ )
               if ( *p < *small )
                    small = p;
          if ( a != small )
               swap( a, small );
     }
}

void swap( int *p, int *q )
{
     int temp;

     temp = *p;
     *p = *q;
     *q = temp;
}
