/*             main program              */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include "main.h"

/* roll_them_bones simulates a game & returns a new bankroll  */
int roll_them_bones( int bet, int bankroll );

main()
{
     int    bankroll = NESTEGG;
     int    ans;           /* 1: play; 0: halt */
     int    bet;           /* player's bet in dollars */


     /* Play until desire or money runs out. */
     do {
          BANKROLL_MSG( bankroll );
          PLAY_PROMPT;
          READ_ANS( ans );
          if ( ans == TRUE ) {
               BET_PROMPT;
               READ_BET( bet );
               while ( bet > LIMIT ) {
                    WARN1( bet, LIMIT );
                    BET_REPROMPT;
                    READ_BET( bet );
               }
               while ( bet > bankroll ) {
                    WARN2( bet, bankroll );
                    BET_REPROMPT;
                    READ_BET( bet );
               }

               /* Update bankroll after a game's played. */
               bankroll = roll_them_bones( bet, bankroll );
          }
     } while ( ans == TRUE && bankroll > 0 );

     if ( bankroll > 0 ){
          WINNER_MSG;
          BANKROLL_MSG( bankroll );
     }
     else
          LOSER_MSG;

     return EXIT_SUCCESS;
}

/*  ROLL_THEM_BONES -- simulates one game   */

#include "roll.h"

int roll_them_bones( int bet, int bankroll )
/* bet in dollars */
/* bankroll in dollars */
{
     void sleep( int how_long ); /* pause for time proportional to
                                    how_long */
     int  ran( int k );  /* random number generator: ran(k) returns
                            an integer in the range 1 through k */
     int  mark;   /* sum of dice on 1st roll */
     int  dice;   /* sum of dice after 1st roll */
     int  double_flag = FALSE; /* TRUE if dice equals 2 or 12 */

     /* Roll the dice the first time to get the player's "mark". */
     mark = ran( 6 ) + ran( 6 );
     PRINT_MARK( mark );

     /* Check for 7 or 11. */
     if ( mark == 7  ||  mark == 11 ) {
          LOSE_MSG( bet );
          bankroll += bet;
          return ( bankroll );   /* Exit a winner. */
     }

     /* Check for possibility of double payoff on bet. */
     if ( mark == SNAKE_EYES  ||  mark == BOX_CARS ) {
          double_flag = TRUE;
          POSSIBLE_DOUBLE_MSG;
     }

     /* Roll until DICE equals either MARK or 7 or 11. */
     do {
          dice = ran( 6 ) + ran( 6 );
          PRINT_ROLL_MSG;
          NL;
          sleep( SHUT_EYES ); /* pause a bit to simulate pause
                                 between rolls of the dice. */
          PRINT_DICE( dice );
     } while ( dice != mark  &&  dice != 7  &&  dice != 11 );

     if ( dice == mark )
          if ( double_flag ) {
               bankroll += 2 * bet;
               DOUBLE_WIN_MSG( 2 * bet );
          }
          else {
               bankroll += bet;
               REGULAR_WIN_MSG( bet );
          }
     else {
          bankroll -= bet;
          CONSOLE_MSG( bet );
     }
     return ( bankroll );
}

/*   ran returns a random integer in the range 1 to k.

     ran invokes the library function rand which returns a random
     integer in the range 0 to RAND_MAX (defined in stdlib.h).     */

int ran( int k )
{
     double x = RAND_MAX + 1.0;
     int y;

     y = 1 + rand() * (k / x);
     return ( y );
}

/* sleep pauses for time proportional to how_long */
void sleep( int how_long )
{
     int i, j;

     for ( i = 0; i < how_long; ++i )
          for ( j = 0; j < INT_MAX; ++j ) /* INT_MAX is defined in
                                                          limits.h */
               ;
}
