/*  This program tracks sales and inventory for a dozen brands  */
/*  of cars in a used-car business. The brands are coded as     */
/*  integers 0 through 11.                                      */
/*                                                              */
/*  At each day's start, the user initializes                   */
/*                       cars_in_stock[ brand ]                 */
/*  to total inventory for a given brand, and                   */
/*                     total_cars_sold[ brand ]                 */
/*  to zero. With each sale, the program updates                */
/*                     total_cars_sold[ brand ]                 */
/*  by cars_sold. At day's end, the user enters a negative      */
/*  integer for a brand, which causes the program to generate   */
/*  a summary report.                                           */

#include <stdio.h>
#include <stdlib.h>

#define NUM_BRANDS 12 /* number of car brands currently handled */

main()
{
       int  cars_in_stock[ NUM_BRANDS ];
       int  total_cars_sold[ NUM_BRANDS ];
       int  cars_sold;
       int  brand;

       /* Initialize cars_in_stock and total_cars_sold for each
          brand. */
       for ( brand = 0; brand < NUM_BRANDS; ++brand ) {
          printf( "\n\n\tCars in stock for brand: %d  ", brand );
          scanf( "%d", &cars_in_stock[ brand ] );
          total_cars_sold[ brand ] = 0;
       }

       /* Record sales, updating total_cars_sold, until user
          signals halt.*/
       printf( "\n\n\n" );

       /* Loop until user signals halt by setting brand less than
          zero. */
        while ( brand >= 0 ) {
            printf( "\n\n\t Which brand was sold? " );
            scanf( "%d", &brand );
            /* BRAND in bounds? */
            if ( brand >= 0 && brand < NUM_BRANDS ) {
                 printf( "\n\t How many cars in sale? " );
                 scanf( "%d", &cars_sold );
                 total_cars_sold[ brand ] += cars_sold;
            }
       }

       /* Generate daily report for each brand. */
       printf( "\n\n\n\n\t\tDAILY REPORT" );
       printf( "\n\t\t----- ------" );
       for ( brand = 0; brand < NUM_BRANDS; ++brand ) {
          printf( "\n\n\t\tBrand #:\t\t\t%d", brand );
          printf( "\n\t\tInventory at day's start:\t%d",
              cars_in_stock[ brand ] );
          printf( "\n\t\tTotal sales:\t\t\t%d",
              total_cars_sold[ brand ] );
          printf( "\n\t\tInventory at day's end:\t\t%d",
              cars_in_stock[ brand ] - total_cars_sold[ brand ] );
          printf( "\n\t\tSales as percentage of inventory:\t\t%f",
               100 * ( (float) total_cars_sold[ brand ] /
               ( float ) cars_in_stock[ brand ] ) );
       }

       return EXIT_SUCCESS;
}
