#include <stdio.h>
#include <stdlib.h>

typedef  enum seven_deadly_sins { anger, lust, envy, gluttony,
                                  pride, sloth, covetousness }
SINS;

#define  START   anger /* start vertex */
#define  SIZE    7     /* number of vertices */

int visited[ SIZE ];   /* 1 means visited; 0 means not visited */
SINS sin_queue[ SIZE ];

int  adj_matrix[ SIZE ][ SIZE ];

/* queue indexes and counter */
int  front = 0, rear = 0, count = 0;

void  initialize( void ), bfs1( SINS start );
void  insert( SINS item ), visit( SINS sin );
SINS delete( void );

main()
{
     initialize();
     bfs1( START );

     return EXIT_SUCCESS;
}

/*   The  function  initialize  initializes the array adj_matrix which
     holds  SIZE*SIZE  integers,  each 1 or 0 to indicate the presence
     or absence of an edge.                                        */

void  initialize( void )
{
     adj_matrix[ anger ][ anger ] = 0;
     adj_matrix[ anger ][ lust ] = 1;
     adj_matrix[ anger ][ envy ] = 1;
     adj_matrix[ anger ][ gluttony ] = 1;
     adj_matrix[ anger ][ pride ] = 0;
     adj_matrix[ anger ][ sloth ] = 0;
     adj_matrix[ anger ][ covetousness ] = 0;
     adj_matrix[ lust ][ anger ] = 1;
     adj_matrix[ lust ][ lust ] = 0;
     adj_matrix[ lust ][ envy ] = 1;
     adj_matrix[ lust ][ gluttony ] = 0;
     adj_matrix[ lust ][ pride ] = 0;
     adj_matrix[ lust ][ sloth ] = 0;
     adj_matrix[ lust ][ covetousness ] = 0;
     adj_matrix[ envy ][ anger ] = 1;
     adj_matrix[ envy ][ lust ] = 1;
     adj_matrix[ envy ][ envy ] = 0;
     adj_matrix[ envy ][ gluttony ] = 0;
     adj_matrix[ envy ][ pride ] = 1;
     adj_matrix[ envy ][ sloth ] = 1;
     adj_matrix[ envy ][ covetousness ] = 0;
     adj_matrix[ gluttony ][ anger ] = 1;
     adj_matrix[ gluttony ][ lust ] = 0;
     adj_matrix[ gluttony ][ envy ] = 0;
     adj_matrix[ gluttony ][ gluttony ] = 0;
     adj_matrix[ gluttony ][ pride ] = 0;
     adj_matrix[ gluttony ][ sloth ] = 1;
     adj_matrix[ gluttony ][ covetousness ] = 0;
     adj_matrix[ pride ][ anger ] = 0;
     adj_matrix[ pride ][ lust ] = 0;
     adj_matrix[ pride ][ envy ] = 1;
     adj_matrix[ pride ][ gluttony ] = 0;
     adj_matrix[ pride ][ pride ] = 0;
     adj_matrix[ pride ][ sloth ] = 0;
     adj_matrix[ pride ][ covetousness ] = 0;
     adj_matrix[ sloth ][ anger ] = 0;
     adj_matrix[ sloth ][ lust ] = 0;
     adj_matrix[ sloth ][ envy ] = 1;
     adj_matrix[ sloth ][ gluttony ] = 1;
     adj_matrix[ sloth ][ pride ] = 0;
     adj_matrix[ sloth ][ sloth ] = 0;
     adj_matrix[ sloth ][ covetousness ] = 1;
     adj_matrix[ covetousness ][ anger ] = 0;
     adj_matrix[ covetousness ][ lust ] = 0;
     adj_matrix[ covetousness ][ envy ] = 0;
     adj_matrix[ covetousness ][ gluttony ] = 0;
     adj_matrix[ covetousness ][ pride ] = 0;
     adj_matrix[ covetousness ][ sloth ] = 1;
     adj_matrix[ covetousness ][ covetousness ] = 0;
}

/*   The  function  bfs1  does a breadth-first search beginning at the
     vertex start.                                                 */

void  bfs1( SINS start )
{
     SINS sin, next;

     /* Put start in queue and mark it as visited. */
     insert( start );
     visit( start );
     visited[ start ] = 1;

     /* Search until queue is empty. */
     /* next < 0 means empty queue. */
     while ( ( next = delete() ) >= 0 )
          /* Queue up unvisited adjacent vertices. */
          for ( sin = 0; sin < SIZE; ++sin )
               if ( adj_matrix[ next ][ sin ] == 1
                    &&  !visited[ sin ] ) {
                    /* Put sin in queue and mark it as visited. */
                    insert( sin );
                    visit( sin );
                    visited[ sin ] = 1; /* Mark vertex as visited. */
               }
}

/* Print a visit message. */
void  visit( SINS sin )
{
     switch( sin ) {
     case anger:
          printf( "\n\nAnger has been visited.\n\n" );
          break;
     case lust:
          printf( "\n\nLust has been visited.\n\n" );
          break;
     case envy:
          printf( "\n\nEnvy has been visited.\n\n" );
          break;
     case gluttony:
          printf( "\n\nGluttony has been visited.\n\n" );
          break;
     case pride:
          printf( "\n\nPride has been visited.\n\n" );
          break;
     case sloth:
          printf( "\n\nSloth has been visited.\n\n" );
          break;
     case covetousness:
          printf( "\n\nCovetousness has been visited.\n\n" );
          break;
     }
}

/* Insert item in queue. */
void insert( SINS item )
{
     if ( count == SIZE )
          printf( "\n\nFULL QUEUE\n\n" );
     else {
          sin_queue[ rear ] = item;
          rear = ++rear % SIZE;
          ++count;
     }
}

/* Delete an item from queue and return it. */
/* If queue is empty, return -1. */
SINS delete( void )
{
     SINS front_value;

     if ( count == 0 )
          return -1;
     front_value = sin_queue[ front ];
     front = ++front % SIZE;
     --count;

     return front_value;
}
