#include <stdio.h>
#include <stdlib.h>

int echo_line( void );
void print_stars( int size );

main()
{
   int value;

   while ( echo_line() != EOF ) {
      scanf( "%d", &value );
      print_stars( value );
   }

   return EXIT_SUCCESS;
}

int echo_line( void )
{
   char c;

   if ( scanf( " %c", &c ) == EOF )
      return ( EOF );

   for ( ; ; c = getchar() ) {
      putchar( c );
      if ( c == '\n' )
         return ( c );
   }
}

void print_stars( int size )
{
   int i;

   for ( i = 1; i <= size / 2; i++ )
      putchar( '*' );
   putchar( '\n' );
}
