/*   This program times various sorting functions; main invokes
     the function timer which invokes and times a sort. The
     arguments to timer are

          --the name of the algorithm
          --an array that holds the ints to sort
          --the number of items to sort
          --a pointer to the function that sorts              */

#include <stdio.h>
#include <time.h>
#include <stdlib.h>

#define NUMB_OF_ARRAY_SIZES  8
#define MAX_SIZE_TO_SORT  5000

void fill_array( int a[], int count );
void selection_sort( int a[], int count );
void quicksort( int a[], int count );
void timer( char *alg_name,
            int a[],
            int size,
            void ( *sort_alg )( int [], int ) );

main()
{
     int i;   /* loop counter */
     /* sort arrays of size 100, 200, 500, 1000, 2000,
        3000, 4000, 5000 */
     int numb[] = { 100, 200, 500, 1000, 2000, 3000,
                    4000, 5000 };
     int a[ MAX_SIZE_TO_SORT ]; /* holds ints to sort */

     for ( i = 0; i < NUMB_OF_ARRAY_SIZES; i++ ) {
          printf( "\n\n\nSort %d items\n", numb[ i ] );
          fill_array( a, numb[ i ] );
          timer( "Selection sort", a, numb[ i ],
                 selection_sort );
          timer( "Quicksort", a, numb[ i ], quicksort );
     }

     return EXIT_SUCCESS;
}

/*   timer receives four arguments

          --the name of the algorithm
          --an array that holds the ints to sort
          --the number of items to sort
          --a pointer to the function that sorts

     timer first copies the array that holds the ints to sort to
     the local array b, so that the data passed are not changed.
     After printing the name of the sorting algorithm, the
     function is invoked and the time to sort is printed. The
     time is measured by invoking the system functions time,
     which returns the current calendar time, and difftime,
     which returns the difference in seconds between two
     calendar times.                                               */

void timer( char *alg_name, /* string with name of algorithm */
            int a[],        /* data to sort */
            int size,       /* number of ints to sort */
            void ( *sort_alg )( int [], int ) ) /* pointer to
                                                     sort function */
{
     int i; /* loop counter */
     int b[ MAX_SIZE_TO_SORT ]; /* array to sort */
     time_t start; /* time when sort begins */
     time_t stop;  /* time when sort ends */

     /* Copy a to b. b will be sorted. */
     for ( i = 0; i < size; i++ )
          b[ i ] = a[ i ];

     printf( "\tAlgorithm: %s\n", alg_name );
     start = time( NULL );
     /* sort b[ 0 ], ..., b[ size - 1 ] */
     ( *sort_alg )( b, size );
     stop = time( NULL );
     printf( "\t\tTime = %f seconds\n",
                  difftime( stop, start ) );
}

/*   fill_array writes random ints into a[ 0 ], ..., a[ count - 1 ]. 
     The library function rand is used, and rand returns a random 
     integer.                                                      */

void fill_array( int a[], int count )
/* a[] is an array of count integers */
{
     int i;

     for ( i = 0; i < count; i++ )
          a[ i ] = rand();
}

void selection_sort( int a[], int count )
/* a[] is the array to sort */
/* sort a[ 0 ], ..., a[ count - 1 ] */
{
     /* code to implement selection_sort */
}

void quicksort( int a[], int count )
/* a[] is the array to sort */
/* sort a[ 0 ], ..., a[ count - 1 ] */
{
     /* code to implement quicksort */
}
