#include <stdio.h>
#include <stdlib.h>

/*  Turbo/Borland C++ Users:
       This program may not work because of a "floating point
       formats not linked" problem. Borland can furnish a patch.
*/

#define  SIZE  100

typedef  struct customer {
   char    lname[ 25 ]; /* last name */
   char    fname[ 15 ]; /* first name */
   int     account_no;  /* account number */
   float   balance;     /* balance */
} CUSTOMER;

CUSTOMER  *customers[ SIZE ];

int    front = 0, rear = 0;   /* exit and entry positions in queue */
int    count = 0;             /* count of items in queue */

CUSTOMER *insert( CUSTOMER cust ), *remov( void );
void  get_data( CUSTOMER *ptr ), put_data( const CUSTOMER *ptr );

main()
{
     int ans, flag;
     CUSTOMER cu, *ptr;

     /* do queue operations until user signals halt */
     do {
          do {
               printf( "\n\n\tEnter 1 to insert, 2 to remove:  " );
               scanf( "%d", &ans );
               printf( "\n" );
               switch ( ans ) {
               case 1: /* get a CUSTOMER and add to queue */
                    get_data( &cu );
                    if ( insert( cu ) == NULL )
                         printf( "\n\nQUEUE FULL\n\n" );
                    break;
               case 2: /* delete a CUSTOMER from queue and print */
                    if ( ( ptr = remov() ) != NULL )
                         put_data( ptr );
                    else
                         printf( "\n\nQUEUE EMPTY\n\n" );
                    break;
               default:
                    printf( "\nIllegal response\n" );
                    break;
               }
          } while ( ans != 1 && ans != 2 );
          printf( "\n\n\n1 to continue, 0 to quit: " );
          scanf( "%d", &flag );
          printf( "\n" );
     } while ( flag );

     return EXIT_SUCCESS;
}

/*   get_data prompts the user for a CUSTOMER's last name, first
     name, account_no, and balance stores the data at the address
     passed.                                                       */
void  get_data( CUSTOMER *ptr )
{
     printf( "\nenter the customer's last name: " );
     scanf( "%s", ptr -> lname );
     printf( "\nenter the customer's first name: " );
     scanf( "%s", ptr -> fname );
     printf( "\nenter the customer's account number: " );
     scanf( "%d", &( ptr -> account_no ) );
     printf( "\nenter the customer's balance: " );
     scanf( "%f", &( ptr -> balance ) );
     printf( "\n" );
}

/*   put_data writes the last name, first name, account_no, and
     balance of the CUSTOMER whose address is passed.              */

void put_data( const CUSTOMER *ptr )
{
     printf( "\ncustomer's name: %s, %s\n", ptr -> lname,
          ptr -> fname  );
     printf( "\ncustomer's account number: %d\n",
          ptr -> account_no );
     printf( "\ncustomer's balance: %f\n", ptr -> balance );
}

/*   If the queue is full, insert returns NULL. Otherwise, insert
     allocates storage for a CUSTOMER, copies the data passed into
     the allocated storage, adds a pointer to the CUSTOMER to the
     array, and returns the address of the CUSTOMER added. */

CUSTOMER *insert( CUSTOMER cust )
{
     CUSTOMER *ptr;

     if ( count  >=  SIZE ) /* queue full? */
          return NULL;
     ptr = malloc( sizeof ( CUSTOMER ) ); /* new CUSTOMER */
     *ptr = cust; /* store data */
     customers[ rear ] = ptr; /* add CUSTOMER to queue */
     rear = ++rear % SIZE; /* update rear */
     ++count; /* update count */
     return ptr;
}

/*   If the queue is empty, remov returns NULL. Otherwise, remov
     copies the CUSTOMER at the front to permanent storage, frees the
     queue storage, updates front, and returns the address of the
     CUSTOMER.                                                     */

CUSTOMER *remov( void )
{
     static CUSTOMER removed_cust;

     if ( count == 0 ) /* empty queue? */
          return NULL;
     removed_cust = *customers[ front ]; /* copy CUSTOMER at front */
     free( customers[ front ] ); /* collect garbage */
     front = ++front % SIZE; /* update front */
     --count;
     return &removed_cust;
}
