/* This program computes the first
   max_coeff + 1 terms of the discrete Fourier
   transform (h1,h2) of the function g. g is
   represented as the array

      g[0],...,g[resolution - 1]

   h1 is the cosine component and h2
   is the sine component of the Fourier
   transform. h1 and h2 are represented
   as the arrays

      h1[0],...,h1[max_coeff]
      h2[0],...,h2[max_coeff]

   The program prints the amplitude spectrum

      sqrt( h1[i]^2 + h2[i]^2 )

   for i = 1,...,max_coeff.

   The input must be of the form

   resolution
   g[0] g[1] ... g[resolution - 1]
   max_coeff
*/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#define MAX_RESOLUTION 300

main()
{
   int resolution;
   float scale;
   float h1[ MAX_RESOLUTION ], h2[ MAX_RESOLUTION ],
         g[ MAX_RESOLUTION ];
   float pi = 3.14159265;
   int i, s, t, max_coeff;

   scanf( "%d", &resolution );
   scale = 2 * pi / resolution;

   for ( i = 0; i < resolution; i++ )
      scanf( "%f", &g[ i ] );

   scanf( "%d", &max_coeff );

   /* compute Fourier coefficients */
   for ( s = 0; s <= max_coeff; s++ ) {
      h1[ s ] = h2[ s ] = 0.0;
      for ( t = 0; t < resolution; t++ ) {
         h1[ s ] += g[ t ] * cos( scale * s * t );
         h2[ s ] += g[ t ] * sin( scale * s * t );
      }
   }

   printf( "\n\nSpectrum:\n" );
   for ( i = 1; i <= max_coeff; i++ )
      printf( "%f\n",
              sqrt( h1[ i ] * h1[ i ] + h2[ i ] * h2[ i ] ) );

   return EXIT_SUCCESS;
}
