#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* declare a self-referential structure */
typedef  struct elephant {
      char             name[ 10 ];
      struct elephant  *next;
} ELEPHANT;

void  print_elephants( const ELEPHANT *ptr );

main()
{
     /* define three ELEPHANT variables and one pointer to
        ELEPHANT */
     ELEPHANT  elephant1, elephant2, elephant3, *start;

     /* store elephants' names */
     strcpy( elephant1.name, "Edna" );
     strcpy( elephant2.name, "Elmer" );
     strcpy( elephant3.name, "Eloise" );

     /* link elephants */
     elephant1.next = &elephant2;  /* Edna points to Elmer */
     elephant2.next = &elephant3;  /* Elmer points to Eloise */
     elephant3.next = NULL;        /* Eloise is last */

     /* start contains the address of the first node */
     start = &elephant1;
     print_elephants( start );

     return EXIT_SUCCESS;
}

void  print_elephants( const ELEPHANT *ptr )
{
     int count = 1;

     printf( "\n\n\n" );
     while ( ptr !=  NULL ) {
          printf( "\nElephant number %d is %s.",
               count++, ptr -> name );
          ptr = ptr -> next;
     }
}
