#include <iostream>
#include <ctime>     
#include <cstring>
#include <fstream>
using namespace std;
class Task {
public:
   // constructors-destructor
   Task( const char id[ ] );
  ~Task();
   // set-get methods
   void        setST( time_t st = 0 );
   time_t      getST();
   const char* getStrST();
   void        setFT( time_t ft = 0 );
   time_t      getFT();
   const char* getStrFT();
   void        setID( const char ID[ ] ) {
     strncpy( id, ID, MaxId );
     id[ MaxId ] = '\0';
   }
   const char* getID() { return id; }
   double      getDU();
   void        logToFile();
private:
   enum { MaxId = 50, MaxLogFile = 20 };
   Task(); // default constructor disallowed
   TimeStamp  st;
   TimeStamp  ft;
   char       id[ MaxId + 1 ];
   char       logFile[ MaxLogFile + 1 ];
};

Task::Task( const char ID[ ] ) {
   strncpy( id, ID, MaxId );
   id[ MaxId ] = '\0';
   strcpy( logFile, "log.dat" );
   setST();
   ft = st; // so far, no duration
}
Task::~Task() {
   logToFile(); // if client forgets
}
void Task::logToFile() {
   // set finish if duration still 0
   if ( getFT() == getST() ) 
     setFT();
   // log the Task's vital statistics
   ofstream outfile( logFile, ios::app );
   outfile << endl << "ID: " << id << endl;
   outfile << "  ST: " << getStrST();
   outfile << "  FT: " << getStrFT();
   outfile << "  DU: " << getDU(); 
   outfile << endl;
   outfile.close();
}
void Task::setST( time_t ST ) {
   st.set( ST );
}
time_t Task::getST() {
   return st.get();
}
const char* Task::getStrST() {
   return st.getAsString();
}
void Task::setFT( time_t FT ) {
   ft.set( FT );
}
time_t Task::getFT() {
   return ft.get();
}
const char* Task::getStrFT() {
   return ft.getAsString();
}
double Task::getDU() {
   return difftime( getFT(), getST() );
}
