#include <iostream>
#include <ctime>     
#include <cstring>
using namespace std;
class TimeStamp {
public:
   void        set( long s = 0 );
   time_t      get();
   const char* getAsString();
   const char* getYear();
   const char* getMonth();
   const char* getDay();
   const char* getHour();
   const char* getMinute();
   const char* getSecond();
private:
   const char* extract( int, int );
   time_t stamp;
   char   string[ 30 ]; // holds ctime's return string
};

void TimeStamp::set( long s ) {
   if ( s <= 0 )
     stamp = time( 0 );
   else
     stamp = s;                      
}
time_t TimeStamp::get() { 
   return stamp; 
}
const char* TimeStamp::getAsString() {
   return ctime( &stamp );
}
const char* TimeStamp::extract( int offset, int count ) {
   char temp[ 30 ];
   strcpy( temp, ctime( &stamp ) );
   strncpy( string, temp + offset, count );
   string[ count ] = '\0';  // ensure a string
   return string;
}
const char* TimeStamp::getYear() {
   return extract( 20, 4 );
}
const char* TimeStamp::getMonth() {
   return extract( 4, 3 );
}
const char* TimeStamp::getDay() {
   return extract( 0, 3 );
}
const char* TimeStamp::getHour() {
   return extract( 11, 2 );
}
const char* TimeStamp::getMinute() {
   return extract( 14, 2 );
}
const char* TimeStamp::getSecond() {
   return extract( 17, 2 );
}