#include <iostream>
#include <cmath>
#include <cfloat>
using namespace std;
/** The program reads floating-point numbers from the
    standard input and prints a statistical summary that
    includes the largest value input, the smallest value
    input, the sum of all values input, the mean,
    population variance, and standard deviation. **/
int main() {
   float next,   // next value from standard input
         min,    // minimum value
         max,    // maximum value
         mean,   // average of all values
         sum,    // sum of all values
         sumSqr, // sum of squares of all values,
         var;    // variance of all values
   unsigned count = 0;
   min = FLT_MAX;
   max = FLT_MIN;
   sum = sumSqr = 0.0F;
   // loop until standard input is empty
   while ( cin >> next ) {
      if ( next > max ) // new maximum?
        max = next;
      if ( next < min ) // new minimum?
        min = next;
      sum += next;           // running sum
      sumSqr += next * next; // sum of squares
      count++;               
   }
   mean = sum / count;
   var = sumSqr / count - mean * mean;
   // output results
   cout << "Statistical summary:" << endl;
   cout << '\t' << count << " numbers read." << endl;
   cout << '\t' << "  Maximum:  " << max << endl;
   cout << '\t' << "  Minimum:  " << min << endl;
   cout << '\t' << "  Sum:      " << sum << endl;
   cout << '\t' << "  Mean:     " << mean << endl;
   cout << '\t' << "  Variance: " << var << endl;
   cout << '\t' << "  StdDev:   " << sqrt( var ) << endl;
   return 0;
}