#include <iostream>
#include <fstream>
#include <cstdlib>
#include <cstring>
using namespace std;
const int MaxStr = 50;
const int MaxSize = 80;

class Sequence {
public:
   bool addS( int, char [ ] );
   bool del( int );
   void output();
   Sequence();
   Sequence( char [ ] );
   ~Sequence();
protected:
   char s[ MaxStr ][ MaxSize ];
   char filename[ MaxSize ];
   int last;
   ifstream in;
   ofstream out;
};

bool Sequence::addS( int pos, char entry[ ] ) {
   if ( last == MaxStr - 1
        || pos < 0
        || pos > last + 1 )
      return false;
   for ( int i = last; i >= pos; i-- )
      strcpy( s[ i + 1 ], s[ i ] );
   strcpy( s[ pos ], entry );
   last++;
   return true;
}

bool Sequence::del( int pos ) {
   if ( pos < 0 || pos > last )
      return false;

   for ( int i = pos; i < last; i++ )
      strcpy( s[ i ], s[ i + 1 ] );
   last--;
   return true;
}

void Sequence::output() {
   for ( int i = 0; i <= last; i++ )
      cout << i << "  " << s[ i ] << endl;
}

Sequence::Sequence() {
   last = -1;
   filename[ 0 ] = '\0';
}

Sequence::Sequence( char fname[ ] ) {
   last = -1;
   strcpy( filename, fname );
   in.open( filename );
   if ( !in )
      return;
   while ( last < MaxStr - 1 ) {
      in.getline( s[ last + 1 ], MaxSize );
      if ( !strlen( s[ last + 1 ] ) )
         break;
      last++;
   }
   in.close();
}

Sequence::~Sequence() {
   if ( filename[ 0 ] == '\0' )
      return;
   out.open( filename );
   for ( int i = 0; i <= last; i++ )
      out << s[ i ] << endl;
   out.close();
}

class SortedSeq : public Sequence {
public:
   bool addSS( char [ ] );
   SortedSeq();
   SortedSeq( char [ ] );
protected:
   void sort();
};

void SortedSeq::sort() {
   char temp[ MaxSize ];
   for ( int i = 0; i <= last - 1; i++ ) {
      strcpy( temp, s[ i + 1 ] );
      for ( int j = i; j >= 0; j-- ) {
         if ( strcmp( temp, s[ j ] ) < 0 )
            strcpy( s[ j + 1 ], s[ j ] );
         else
            break;
      }
      strcpy( s[ j + 1 ], temp );
   }
}

bool SortedSeq::addSS( char entry[ ] ) {
   for ( int i = 0; i <= last; i++ )
      if ( strcmp( entry, s[ i ] ) <= 0 )
         break;
   return addS( i, entry );
}

SortedSeq::SortedSeq() : Sequence() { }

SortedSeq::SortedSeq( char fname[ ] ) : Sequence( fname ) {
   sort();
}