#include <iostream>
#include <cstdlib>
using namespace std;
int get_strat();
int get_no_games();
char get_each_game_flag();
int play_games( int strat, 
                int no_games, 
                char each_game_flag );

int main() {
   int strat, no_games, won;
   char each_game_flag;
   strat = get_strat();
   no_games = get_no_games();
   each_game_flag = get_each_game_flag();
   won = play_games( strat, no_games, each_game_flag );
   cout << "Games played = " << no_games << endl;
   cout << "Games won = " << won << endl;
   cout << "Percent won = " <<
           100.0 * won / no_games << endl;
   return 0;
}

int get_strat() {
   int strat;
   do {
      cout << "1--never switch" << endl
           << "2--always switch" << endl
           << "3--randomly switch" << endl
           << "Your choice? ";
      cin >> strat;
   } while ( strat < 1 && strat > 3 );

   return strat;
}

int get_no_games() {
   int no_games;
   cout << "Play how many games? ";
   cin >> no_games;
   return no_games;
}

char get_each_game_flag() {
   char each_game_flag;
   cout << "Display results of each game [Y]es, [N]o? ";
   cin >> each_game_flag;
   return each_game_flag;
}

int play_games( int strat, 
                int no_games, 
                char each_game_flag ) {
   int i, car, host, sw_flag, person, win;
   for ( win = 0, i = 0; i < no_games; i++ ) {
      if ( each_game_flag == 'Y' )
         cout << "\n\nBeginning a new game\n";
      // pick person's door
      person = rand() % 3;
      if ( each_game_flag == 'Y')
         cout << "Person picks door " << person << endl;
      // place car behind a door
      car = rand() % 3;
      if ( each_game_flag == 'Y' )
         cout << "Car is behind door " << car << endl;
      // if person has picked the car, the host
      // has a random choice of doors to open
      if ( person == car )
         host = ( 1 + person + rand() % 2 ) % 3;
      // otherwise the host's door is the door
      // other than the person's that does not
      // contain the car
      else {
         host = ( person + 1 ) % 3;
         if ( host == car )
            host = ( host + 1 ) % 3;
      }
      if ( each_game_flag == 'Y' )
         cout << "Host opens door " << host << endl;
      switch ( strat ) {
      case 1: // never switch
         sw_flag = 0;
         break;
      case 2: // always switch
         sw_flag = 1;
         break;
      case 3: // randomly switch
         sw_flag = rand() % 2;
         break;
      }
      if ( sw_flag ) {
         // the person switches to the door
         // the host did not open
         person = ( person + 1 ) % 3;
         if ( person == host )
            person = ( person + 1 ) % 3;
         if ( each_game_flag == 'Y' )
            cout << "Switch to door " << person<< endl;
      }
      if ( car == person ) {
         if ( each_game_flag == 'Y' )
            cout << "Win" << endl;
         win++;
      }
      else if ( each_game_flag == 'Y' )
         cout << "Loss" << endl;
   }
   return win;
}