#include <iostream>
#include <cstring>
using namespace std;
const int asize = 512;

class Film {
public:
   void store_title( const char[ ] );
   void store_director( const char[ ] );
   void store_time( int );
   void store_quality( int );
   void output();
private:
   char title[ asize ];
   char director[ asize ];
   int time; // in minutes
   int quality; // 0 (bad) to 4 (tops)
};

void Film::store_title( const char t[ ] ) {
   strcpy( title, t );
}

void Film::store_director( const char d[ ] ) {
   strcpy( director, d );
}

void Film::store_time( int t ) {
   time = t;
}

void Film::store_quality( int q ) {
   quality = q;
}

void Film::output() {
   cout << "Title: " << title << endl;
   cout << "Director: " << director << endl;
   cout << "Time: " << time << " mins" << endl;
   cout << "Quality: ";
   for ( int i = 0; i < quality; i++ )
      cout << '*';
   cout << endl;
}

class DirectorCut : public Film {
public:
   void store_rev_time( int );
   void store_changes( const char [ ] );
   void output();
private:
   int rev_time;
   char changes[ asize ];
};

void DirectorCut::store_rev_time( int t ) {
   rev_time = t;
}

void DirectorCut::store_changes( const char s[ ] ) {
   strcpy( changes, s );
}

void DirectorCut::output() {
   Film::output();
   cout << "Revised time: " << rev_time << " mins" << endl;
   cout << "Changes: " << changes << endl;
}

class ForeignFilm : public Film {
public:
   void store_language( const char [ ] );
   void output();
private:
   char language[ asize ];
};

void ForeignFilm::store_language( const char l[ ] ) {
   strcpy( language, l );
}

void ForeignFilm::output() {
   Film::output();
   cout << "Language: " << language << endl;
}