const int MaxWord = 100;
const int MaxEntries = 100;

class Entry {
public:
   Entry();
   void add( const char*, const char* );
   bool match( const char* ) const;
   void operator=( const char* );
   friend ostream& operator<<( ostream&, const Entry& );
   bool& valid() { return flag; }
private:
   char word[ MaxWord + 1 ];
   char def[ MaxWord + 1 ];
   bool flag;
};

void Entry::operator=( const char* str ) {
   strcpy( def, str );
   flag = true;
}

Entry::Entry() {
   word[ 0 ] = '\0';
   def[ 0 ] = '\0';
   flag = false;
}

ostream& operator<<( ostream& out, const Entry& e ) {
   out << e.word << " defined as: "
       << e.def;
   return out;
}

void Entry::add( const char* w, const char* d ) {
   strcpy( word, w );
   strcpy( def, d );
}

bool Entry::match( const char* key ) const {
   return strcmp( key, word ) == 0;
}

class Dict {
public:
   friend ostream& operator<<( ostream&, Dict& );
   Entry& operator[ ]( const char* );
private:
   Entry entries[ MaxEntries + 1 ];
};

ostream& operator<<( ostream& out, Dict& d ) {
   for ( int i = 0; i < MaxEntries; i++ )
      if ( d.entries[ i ].valid() )
         out << d.entries[ i ] << endl;
   return out;
}

Entry& Dict::operator[ ]( const char* k ) {
   for ( int i = 0; 
         i < MaxEntries && entries[ i ].valid(); 
         i++ )
      if ( entries[ i ].match( k ) )
         return entries[ i ];
   entries[ i ].add( k , "*** not in dictionary" );
   return entries[ i ];
}