#include <iostream>
#include <fstream>
#include <iomanip>
#include <cstdlib>
#include <cstring>
using namespace std;
const int MaxNo = 30; // max numb of names and addresses
const int MaxFld = 81; // max length of one record
const char filename[ ] = "address.dat";
const int RespSize = 30; // max length of user response
void show( char list[ ][ MaxFld ], int no );
bool add( char name[ ], char list[ ][ MaxFld ], int& no );
bool del( int i, char list[ ][ MaxFld ], int& no );
void init( char list[ ][ MaxFld ], int& no );
void quit( char list[ ][ MaxFld ], int no );

int main() {
   char addr[ MaxNo ][ MaxFld ];
   char name[ MaxFld ];
   char resp[ RespSize ];
   int number;
   int index;
   // read in names from a file if it exists
   // and set number to the number of records
   init( addr, number );
   do {
      cout << "\n\n[S]how names and addresses\n"
           << "[A]dd a name and address\n"
           << "[D]elete a name and address\n"
           << "[Q]uit\n"
           << "Your choice? ";
      cin.getline( resp, RespSize );
      switch ( resp[ 0 ] ) {
      case 'S':
      case 's':
         show( addr, number );
         break;
      case 'A':
      case 'a':
         cout << "Name and address to add\n";
         cin.getline( name, MaxFld );
         if ( !add( name, addr, number ) )
            cout << "\a*** Out of room, unable to add: "
                 << name << endl;
         break;
      case 'D':
      case 'd':
         cout << "Number of name to delete? ";
         cin.getline( resp, RespSize );
         index = atoi( resp );
         if ( !del( index, addr, number ) )
            cout << "\a*** Unable to delete number: "
                 << index << endl;
         break;
      case 'Q':
      case 'q':
         quit( addr, number );
         break;
      default:
         cout << "\a*** Illegal choice; try again\n";
         break;
      }
   } while ( resp[ 0 ] != 'Q' && resp[ 0 ] != 'q' );
   return 0;
}

// show prints the records and numbers them
// starting with zero. The numbers are printed
// in a field of width 3, which is why
// setw( 3 ) is used.

// show also prints PerScreen (20) records per screen.
void show( char list[ ][ MaxFld ], int no ) {
   int i;
   char resp[ RespSize ];
   const int PerScreen = 20;
   for ( i = 0; i < no; i++ ) {
      cout << setw( 3 ) << i << ' '
           << list[ i ] << endl;
      if ( ( i + 1 ) % PerScreen == 0 ) {
         cout << "Hit RETURN to continue: ";
         cin.getline( resp, RespSize );
      }
   }
}

// add adds a record if possible and
// updates the number of records
bool add( char name[ ], char list[ ][ MaxFld ], int& no ) {
   int i;
   // out of room?
   if ( no >= MaxNo )
      return false;
   // find correct position for name
   for ( i = no - 1;
         i >= 0 && strcmp( name, list[ i ] ) < 0;
         i-- )
      strcpy( list[ i + 1 ], list[ i ] );
   strcpy( list[ i + 1 ], name );
   no++;
   return true;
}

// del deletes the record at index i
// and updates the number of records
bool del( int i, char list[ ][ MaxFld ], int& no ) {
   int j;
   // is i in bounds?
   if ( i < 0 || i >= no )
      return false;
   // move names down to delete entry i
   for ( j = i; j < no - 1; j++ )
      strcpy( list[ j ], list[ j + 1 ] );
   no--;
   return true;
}

// init reads names from the file address.dat
// and sets no to the number of records read.
// If address.dat does not exist, init simply sets
// no to zero and returns.
void init( char list[ ][ MaxFld ], int& no ) {
   ifstream in;
   in.open( filename );
   no = 0;
   // check if file exists; if not, return.
   if ( !in )
      return;
   // read records until out of room or end-of-file
   while ( no < MaxNo ) {
      in.getline( list[ no ], MaxFld );
      if ( !strlen( list[ no ] ) )
         break;
      no++;
   }
   in.close();
}

// quit writes the records to address.dat
void quit( char list[ ][ MaxFld ], int no ) {
   ofstream out;
   out.open( filename );
   int i;
   // write records to address.dat
   for ( i = 0; i < no; i++ )
      out << list[ i ] << endl;
   out.close();
}