
// Project KidArray3
// Class MyApplet

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.util.StringTokenizer;
public class MyApplet extends Applet implements ActionListener
{
    // Declare instance variables.
    private String[] kidStrings =
        {"Jane,F,29", "Tom,M,31", "Susan,F,28",
         "Bill,M,35", "Karen,F,34"};
    private Kid[] kids;
    private TextField soughtName;
    private TextField soughtGender;
    private TextField soughtAge;
    private Button find;
             
    public void init()
    {
        int i, anAge;
        String aName;
        char aGender;
        StringTokenizer st;
    
        // Create array of Kid reference variables.
        kids = new Kid[kidStrings.length];
        
        // Create Kid objects and place them in kids array.
        for(i = 0; i < kidStrings.length; i++)
        {
            st = new StringTokenizer(kidStrings[i], ",");
            aName = st.nextToken();
            aGender = st.nextToken().charAt(0);
            anAge = Integer.parseInt(st.nextToken());
            kids[i] = new Kid(aName, aGender, anAge);
        }
        
        // Create component objects.
        soughtName = new TextField(12);        
        soughtGender = new TextField(12);
        soughtAge = new TextField(12);
        find = new Button("Get Kid Info");
        
        // Add components to applet.
        add(soughtName);
        add(soughtGender);
        add(soughtAge);
        add(find);
        
        // Add action listener to button.
        find.addActionListener(this);
        
        // Set size of applet.
        setSize(150, 150);
    }
            
    public void actionPerformed(ActionEvent e)
    {
        int i;        

        // Search for name in kids array.
        for(i = 0; i < kids.length; i++)
            if(kids[i].getName().equals(soughtName.getText()))
            {
                soughtGender.setText(
                    String.valueOf(kids[i].getGender()));
                soughtAge.setText(
                    String.valueOf(kids[i].getAge()));
                return;
            }
            
        // If name not found, clear gender and age textfields.
        soughtGender.setText("");        
        soughtAge.setText("");
    }
}
