
// Project ComputeWages2
// Class ComputeWages
    
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.util.StringTokenizer;
    
public class ComputeWages extends Applet implements ActionListener
{
    // Instance variables for components.
    private TextField input;
    private TextField output;
    private Button compute;
    
    // This method initializes the applet.
    public void init()
    {
        // Create components.
        input = new TextField(12);
        output = new TextField(12);
        compute = new Button("Compute Wage");
        
        // Add components to applet.
        add(input);
        add(output);
        add(compute);
        
        // Add ActionListener to button.
        compute.addActionListener(this);
        
        // Set size of applet.
        setSize(200, 200);
    }
    
    // This method is required to implement the ActionListener.
    public void actionPerformed(ActionEvent e)
    {
        String s;
        double h, hr, total = 0.0;
        StringTokenizer st;
        
        if(!input.getText().equals(""))
        {
            st = new StringTokenizer(input.getText(), " ");
            h = Double.parseDouble(st.nextToken());           
            hr = Double.parseDouble(st.nextToken());
            if (h > 40.0)
                total += 40.0 * hr + (h - 40.0) * 1.5 * hr;
            else
                total += h * hr;
                
            // Display result.
            output.setText(String.valueOf(total));
            
            // Clear the input textfield for next input.
            input.setText("");
            
            // Transfer focus to next control,
            // namely the input textfield.
            compute.transferFocus();
        }
    }
}
