
/**
 * Project Temperature4
 * Class TempConverter
 *
 * Convert a Celsius temperature to Fahrenheit
 * The Celsius temperature is entered by the user
 * into the textfield control.  A submit button
 * signals the applet to perform the conversion.
 * 
 * Use an Swing user interface.
 * The WindowListener is not needed to close the
 * window when running in BlueJ, but should be
 * included when running at the DOS prompt.
 */

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class TempConverter extends JFrame
{
    // Declare instance variables.
    private JTextField cel;
    private JLabel celLabel;
    public JTextField fahr;
    public JLabel fahrLabel; 
    public JButton button;
    public JPanel panel;
    
    // Constructor.  Celsius temperature is passed in.
    public TempConverter()
    {
        // Create control objects.
        cel = new JTextField(10);
        celLabel = new JLabel("Celsius");
        fahr = new JTextField(10);
        fahrLabel = new JLabel("Fahrenheit");
        button = new JButton("Convert");
        panel = new JPanel();
        
        // Set the layout to FlowLayout.
        panel.setLayout(new FlowLayout());
        
        // Add controls to applet.
        panel.add(cel);
        panel.add(celLabel);
        panel.add(fahr);
        panel.add(fahrLabel);
        panel.add(button);
            
        // Make panel the content pane for window.
        setContentPane(panel);
        
        // Create ClickDetector object.
        ClickDetector cd = new ClickDetector();
        
        // Add clickdetectors to button and cel textfield.
        button.addActionListener(cd);
        cel.addActionListener(cd);
        
        // Add WindowCloser object to user interface.
        addWindowListener(new WindowCloser());
              
        // Set size of window.
        setSize(125, 175);        
        
        // Show user interface.
        show();
    }
       
    // This class defines the ClickDetector that
    // detects when a button is clicked or when return
    // is pressed when a textbox has the focus.
    private class ClickDetector implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            String fahrString, celString;
            int fahrTemp, celTemp;
        
            // Get Celsius temperature from textfield.
            celString = cel.getText();
        
            // Convert temperature to Fahrenheit.
            celTemp = Integer.parseInt(celString);
            fahrTemp = 9 * celTemp / 5 + 32;
            fahrString = String.valueOf(fahrTemp);
        
            // Put Fahrenheit temperature into textfield.
            fahr.setText(fahrString);
        }
    }
        
    // This class is needed to close the window
    // and shut down the application when the close
    // button in the control box is clicked.
    // All other methods are stubs that are required to
    // implement a WindowListener.
    private class WindowCloser implements WindowListener
    {
        public void windowActivated(WindowEvent e) {}
        public void windowDeactivated(WindowEvent e) {}
        public void windowIconified(WindowEvent e) {}
        public void windowDeiconified(WindowEvent e) {}
        public void windowOpened(WindowEvent e) {}
        public void windowClosed(WindowEvent e) {}
        public void windowClosing(WindowEvent e) 
        {
            System.exit(0);    
        }
    }
}
