
/**
 * Project Temperature4
 * Class TempConverter
 *
 * Convert a Celsius temperature to Fahrenheit
 * The Celsius temperature is entered by the user
 * into the textfield control.  A submit button
 * signals the applet to perform the conversion.
 * 
 * Use an AWT user interface, not an applet.
 */

import java.awt.*;
import java.awt.event.*;

public class TempConverter extends Frame
{
    // Declare instance variables.
    private TextField cel;
    private Label celLabel;
    public TextField fahr;
    public Label fahrLabel; 
    public Button button;
    
    // Constructor.  Celsius temperature is passed in.
    public TempConverter()
    {
        // Create control objects.
        cel = new TextField(10);
        celLabel = new Label("Celsius");
        fahr = new TextField(10);
        fahrLabel = new Label("Fahrenheit");
        button = new Button("Convert");
        
        // Set the layout to FlowLayout.
        setLayout(new FlowLayout());
        
        // Add controls to applet.
        add(cel);
        add(celLabel);
        add(fahr);
        add(fahrLabel);
        add(button);
            
        // Create ClickDetector object.
        ClickDetector cd = new ClickDetector();
        
        // Add clickdetectors to button and cel textfield.
        button.addActionListener(cd);
        cel.addActionListener(cd);
        
        // Add WindowCloser object to user interface.
        addWindowListener(new WindowCloser());
              
        // Set size of window.
        setSize(125, 175);        
        
        // Show user interface.
        show();
    }
       
    // This class defines the ClickDetector that
    // detects when a button is clicked or when return
    // is pressed when a textbox has the focus.
    private class ClickDetector implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            String fahrString, celString;
            int fahrTemp, celTemp;
        
            // Get Celsius temperature from textfield.
            celString = cel.getText();
        
            // Convert temperature to Fahrenheit.
            celTemp = Integer.parseInt(celString);
            fahrTemp = 9 * celTemp / 5 + 32;
            fahrString = String.valueOf(fahrTemp);
        
            // Put Fahrenheit temperature into textfield.
            fahr.setText(fahrString);
        }
    }
        
    // This class is needed to close the window
    // and shut down the application when the close
    // button in the control box is clicked.
    // All other methods are stubs that are required to
    // implement a WindowListener.
    private class WindowCloser implements WindowListener
    {
        public void windowActivated(WindowEvent e) {}
        public void windowDeactivated(WindowEvent e) {}
        public void windowIconified(WindowEvent e) {}
        public void windowDeiconified(WindowEvent e) {}
        public void windowOpened(WindowEvent e) {}
        public void windowClosed(WindowEvent e) {}
        public void windowClosing(WindowEvent e) 
        {
            System.exit(0);    
        }
    }
}
