
/**
 * Project Temperature2
 * Class TempConverter
 *
 * Convert a Celsius temperature to Fahrenheit
 * The Celsius temperature is entered by the user
 * into the textfield control.  A submit button
 * signals the applet to perform the conversion.
 * 
 * The inner class ClickDetector is used to implement
 * the ActionListener.  This setup is useful in case
 * we need more than one listener.
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

public class TempConverter extends Applet 
                           implements ActionListener
{
    // Declare instance variables.
    private TextField cel;
    private Label celLabel;
    public TextField fahr;
    public Label fahrLabel; 
    public Button button;
    
    // Constructor.  Celsius temperature is passed in.
    public void init()
    {
        // Create control objects.
        cel = new TextField(10);
        celLabel = new Label("Celsius");
        fahr = new TextField(10);
        fahrLabel = new Label("Fahrenheit");
        button = new Button("Convert");
        
        // Set the layout to FlowLayout.
        setLayout(new FlowLayout());
        
        // Add controls to applet.
        add(cel);
        add(celLabel);
        add(fahr);
        add(fahrLabel);
        add(button);
            
        // Add ActionListener to button.  The ActionListener
        // is the TempConverter object itself.
        button.addActionListener(this);
        cel.addActionListener(this);
              
        // Set size of window.
        setSize(125, 150);                  
    }
       
    public void actionPerformed(ActionEvent e)
    {
        String fahrString, celString;
        int fahrTemp, celTemp;
        
        // Get Celsius temperature from textfield.
        celString = cel.getText();
        
        // Convert temperature to Fahrenheit.
        celTemp = Integer.parseInt(celString);
        fahrTemp = 9 * celTemp / 5 + 32;
        fahrString = String.valueOf(fahrTemp);
        
        // Put Fahrenheit temperature into textfield.
        fahr.setText(fahrString);
    }
}
