
/**
 * Project Temperature1
 * Class TempConverter
 *
 * Convert a Celsius temperature to Fahrenheit
 * The Celsius temperature is hardcoded.
 */

import java.applet.Applet;
import java.awt.*;
import javax.swing.JOptionPane;

public class TempConverter extends Applet 
{
    // Declare instance variables for controls.
    private TextField cel;
    private Label celLabel;
    private TextField fahr;
    private Label fahrLabel; 
    private Button button;
    
    // Constructor.  Celsius temperature is passed in.
    public void init()
    {
        // Create control objects.
        cel = new TextField(10);
        celLabel = new Label("Celsius");
        fahr = new TextField(10);
        fahrLabel = new Label("Fahrenheit");
        button = new Button("Convert");
        
        // Set the layout to FlowLayout.
        setLayout(new FlowLayout());
        
        // Add controls to applet.
        add(cel);
        add(celLabel);
        add(fahr);
        add(fahrLabel);
        add(button);
              
        // Set size of window.
        setSize(125, 150);
               
        // Declare local variables.
        String celString, fahrString;
        int celTemp, fahrTemp;

        // Get Celsius temperature from input dialog,
        // copy into cel textfield.
        celString = JOptionPane.showInputDialog(
            "Enter Celsius Temperature.");
        cel.setText(celString);
        
        // Convert temperature in cel to Fahrenheit.
        celString = cel.getText();
        celTemp = Integer.parseInt(celString);
        fahrTemp = 9 * celTemp / 5 + 32;
        fahrString = String.valueOf(fahrTemp);
        
        // Copy Fahrenheit temperature to fahr textfield.
        fahr.setText(fahrString);                  
    }
}
