/**
 * Project KidsFromFile3
 * Class KidDisplayer
 * 
 * Load Kid data into a Kid array.
 * Then access information by name.
 * Display information in an AWT user interface.
 */

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.StringTokenizer; 
    
public class KidDisplayer extends Frame
{
    // Declare instance variables.
    private TextField name;
    private Button submit;
    private TextArea output;
    private Kid[] kid;
    
    // Constructor
    public KidDisplayer() throws IOException
    {
        // Create controls.    
        name = new TextField(10);
        submit = new Button("Submit");
        output = new TextArea(10, 20);
        
        // Set layout manager.
        setLayout(new FlowLayout());
        
        // Add controls to applet.
        add(name);
        add(submit);
        add(output);
        
        // Add WindowListener object to window.
        addWindowListener(new WindowCloser());
        
        // Add ActionListener to submit button.
        submit.addActionListener(new ClickDetector());

        // Set size of window.
        setSize(200, 250);
        
        // Show window.
        show();

        // Create kid array.
        kid = new Kid[10];  
        
        // Create FileReader and BufferedReader objects.
        FileReader fr = new FileReader("c:\\Kids.csv");
        BufferedReader br = new BufferedReader(fr);
       
        // Declare local variables
        StringTokenizer st;
        String line, name;
        char gender;
        int age, i = 0;
       
        // Load information into array.
        line = br.readLine();
        while(line != null)
        {
            st = new StringTokenizer(line, ",");
            name = st.nextToken().trim();
            gender = st.nextToken().charAt(0);
            age = Integer.parseInt(st.nextToken().trim());
            kid[i] = new Kid(name, gender, age);
            i++;
            line = br.readLine();
        }
    }    
    
    private class ClickDetector implements ActionListener
    {
        // Find and print kid object that matches name
        // in the name textfield.  This is similar to
        // phone example in the Arrays example.
        public void actionPerformed(ActionEvent e)
        {
            String nameToFind;
            boolean nameFound = false;
            int i;
            
            output.setText("");
            nameToFind = name.getText();
            for(i = 0; kid[i] != null; i++)
            {
                if(nameToFind.equals(kid[i].getName()))
                {
                    output.append(kid[i] + "\n");
                    nameFound = true;
                }
            }
            if(!nameFound)
                output.append("Name not found.");        
        }
    }
    
    // Used to close window when close button in
    // control box is clicked.
    private class WindowCloser implements WindowListener
    {
        public void windowOpening(WindowEvent e) {}
        public void windowOpened(WindowEvent e) {}
        public void windowActivated(WindowEvent e) {}
        public void windowDeactivated(WindowEvent e) {}
        public void windowIconified(WindowEvent e) {}
        public void windowDeiconified(WindowEvent e) {}
        public void windowClosed(WindowEvent e) {}
        public void windowClosing(WindowEvent e)
        {
            System.exit(0);
        }  
    }
}
