#include <stdio.h>
#include <stdlib.h>

int  walk_non_recur( int dist );

main()
{
     int  distance,      /* how far to walk */
          count_walks;   /* how many ways to walk distance meters */

     printf( "\nHow far to walk?  " );
     scanf( "%d", &distance );
     if ( distance < 1 )      /* distance must be positive */
        printf( "\n\n\tERROR -- distance must be positive." );
     else {
        count_walks = walk_non_recur( distance );
        printf( "\n\n\tThe robot can walk %d meters in %d ways.\n",
              distance, count_walks );
     }

     return EXIT_SUCCESS;
}

/* iterative version of the walk function */

int  walk_non_recur( int dist )
{
     int  previous,      /* walk(n - 1) */
          current,       /* walk(n)     */
          temp;

     if ( dist <= 2 )
          return dist;

     previous = 1;  /* starts as walk(1) */
     current = 2;   /* starts as walk(2) */

     /* compute walk(3), then walk(4), ..., until walk(dist) */
     --dist;
     while ( --dist ) {
          temp = previous;
          previous = current;
          current += temp;
     }

     return current;
}
