/* This program uses Borland graphics to
   draw the von Koch snowflake at a user-
   specified level.
*/

#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <ctype.h>

/* factor is set to sqrt( 3 ) / 2 by
   graph_vonkoch and is used by
   vonkoch
*/
double factor;

char inbuff[ 80 ]; /* for user input */

void vonkoch( int level, int scale, int rot );
void graph_vonkoch( void );

main()
{
   for ( ; ; ) {
      printf( "\nDo another (y = yes, n = no)? " );
      gets( inbuff );
      if ( toupper( *inbuff ) != 'Y' )
         return EXIT_SUCCESS;
      graph_vonkoch();
   }
}

/* graph_vonkoch sets up the graphics,
   obtains the level from the user,
   and invokes vonkoch to draw the snowflake.
*/
void graph_vonkoch( void )
{
   int gdriver = DETECT, gmode, errorcode, level;

   printf( "Enter level: " );
   gets( inbuff );
   level = atoi( inbuff );

   /* gdriver is set to DETECT, which asks
      the system to autodetect the proper
      graphics driver. gmode will be set
      to the highest resolution of the
      driver selected. "" means use
      current directory to look for the
      graphics driver. */
   initgraph( &gdriver, &gmode, "" );

   errorcode = graphresult();
   if ( errorcode != grOk )
   {
      printf( "Graphics error: %s\n", grapherrormsg( errorcode ) );
      return;
   }

   factor = sqrt( 3 ) / 2;
   moveto( 0, 0 );
   /* Draw snowflake.
      level = user-specified level
      getmaxx() = horizontal resolution
      0 = start drawing to the right */
   vonkoch( level, getmaxx(), 0 );

   /* getmaxy() = vertical resolution,
      so print message halfway down. */
   outtextxy( 0, getmaxy() / 2, "Press any key to continue" );
   getch(); /* get char, no echo */
   closegraph();
}
/* Draw snowflake at the specified level, to the specified
   scale, rot*60 degrees clockwise from the horizontal.
   level == 0, which is a straight line, is the most
   primitive level. If level > 0, each line segment in
                           _  _
                            \/

   is replaced by a von Koch snowflake of level n - 1.

   linerel(x,y) (draw line relative) draws a line from
   the current pixel position (p,q) to (p + x, q + y).
*/
void vonkoch( int level, int scale, int rot )
{
   if ( level == 0 )
      switch ( rot ) {
      case 0:
         linerel( scale, 0 );
         return;
      case 1:
         linerel( scale / 2, scale * factor );
         return;
      case 2:
         linerel( -scale / 2, scale * factor );
         return;
      case 3:
         linerel( -scale, 0 );
         return;
      case 4:
         linerel( -scale / 2, -scale * factor );
         return;
      case 5:
         linerel( scale / 2, -scale * factor );
         return;
      }

   vonkoch( level - 1, scale / 3, rot );
   vonkoch( level - 1, scale / 3, ( rot + 1 ) % 6 );
   vonkoch( level - 1, scale / 3, ( rot + 5 ) % 6 );
   vonkoch( level - 1, scale / 3, rot );
}
