     /* This program reads a series of real numbers from the standard
     input and prints a statistical summary of the data that includes
     the largest value input, the smallest value input, the sum of
     all values read, the mean (average) of all values input, the
     population variance, and the standard deviation.              */

     #include <stdio.h>
     #include <math.h>

     main()
     {
          float x, /* current value input */
                max, /* largest value seen so far */
                min, /* smallest value seen so far */
                sum, /* sum of all values seen so far */
                mean, /* mean of all values read */
                sum_of_squares, /* sum of squares of all
                                   values seen so far */
                variance; /* variance of all values read */
          int   count; /* number of values read so far */

          if ( scanf( "%f", &x ) == EOF )  /* empty file? */
               printf( "0 data items read\n" );
          else {
               max = min = sum = x;
               count = 1;
               sum_of_squares = x * x;
               while ( scanf( "%f", &x ) != EOF ) {
                    count += 1;
                    if ( x > max )  /* new high? */
                         max = x;
                    if ( x < min )  /* new low? */
                         min = x;
                    sum += x;
                    sum_of_squares += x * x;
               }
               printf( "%d data items read\n", count );
               printf( "maximum value read = %f\n", max );
               printf( "minimum value read = %f\n", min );
               printf( "sum of all values read = %f\n", sum );
               mean = sum / count;
               printf( "mean = %f\n", mean );
               variance = sum_of_squares / count - mean * mean;
               printf( "variance = %f\n", variance );
               printf( "standard deviation = %f\n",
                    sqrt( variance ) );
          }
     }

