/* sort_str sorts an array of strings. The sort
   is on substrings beginning at a given index
   and having a given length. The arguments to sort_str are:
      
         s -- array of strings to sort
         numb_elts -- number of strings
         str_size -- size in bytes of each string (all strings must
            be the same length)
         start -- index of substring on which to sort
         length -- length of substring on which to sort
 */

#include <stdlib.h>
#include <string.h>

static int strt, len;

static int cmp( const void *, const void * );

void sort_str( void *s, int numb_elts, int str_size,
               int start, int length )
{
   strt = start;
   len = length;

   /* qsort is the standard implementation of quicksort. */
   qsort( s, numb_elts, str_size, cmp );
}

static int cmp( const void *a, const void *b )
{
   return strncmp( ( ( char * ) a ) + strt,
                     ( ( char * ) b ) + strt, len );
}
