/***** BEGIN sales.h *****/

/** structure member macros **/
#define MaxName  (100) /* last name */  
#define MaxReg     (2) /* 2 character region code */      
#define MaxYear    (4) /* current year */
#define MaxAccs  (100) /* maximum number of accounts */ 

/** array sizes **/
#define MaxSales      (100)
#define MaxSalesPer   (100)

/** input file names **/
#define SalesFile    "sales.dat"
#define SalesPerFile "sper.dat"

/** miscellany **/ 
#define MaxBuffer  (500) /* input buffer */
#define AccDel     '#'   /* delimits accounts from other fields */

typedef struct sales {   
  int    accId;                  /* account id */   
  char   accName[ MaxName + 1 ]; /* account name */
  float  act;                    /* actual sales */
  float  proj;                   /* projected sales */
} Sales;

typedef struct salesPer { 
  Sales*  accs[ MaxAccs ];     /* accounts */  
  int     accCnt;              /* accounts count */
  char    name[ MaxName + 1 ]; /* salesperson */
  char    boss[ MaxName + 1 ]; /* supervisor */
  char    reg[ MaxReg + 1 ];   /* sales region */
  float   base;                /* base salary */
  float   bonus;               /* year to date */
} SalesPer;
 
/***** END sales.h *****/

