/*   This program reads a string of up to 100 characters with no
     embedded blanks and writes the reversed string. The function
     rev, invoked with the array as its single argument, does the
     work. The original and reversed strings occupy the same storage.
                                                                   */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void rev( char *s );

main()
{
     char str[ 101 ]; /* storage for up to 100 chars and a null
                                                        terminator */
     printf( "\n\nEnter a string:\t" );
     scanf( "%s", str );
     rev( str );
     printf( "\n\nReversed string:\t%s", str );
     return EXIT_SUCCESS;
}

/*   rev expects a pointer to a character string. It reverses the
     characters in the string leaving the null terminator in place. */

void rev( char *s )
{
     char temp, *end;

     end = s + strlen( s ) - 1; /* end points to last nonnull
                                   character in s */
     while ( s < end ) {
          temp = *s;
          *s++ = *end;
          *end-- = temp;
     }
}
