#include <stdio.h>
#include <stdlib.h>

/*  Turbo/Borland C++ Users:
       This program make not work because of a "floating point
       formats not linked" problem. Borland can furnish a patch.
*/

#define  SIZE  100

typedef  struct customer {
   char    lname[ 25 ];    /* last name */
   char    fname[ 15 ];    /* first name */
   int     account_no;     /* account number */
   float   balance;        /* balance */
   struct  customer *succ; /* successor on the queue */
} CUSTOMER;

CUSTOMER  *front, *rear; /* exit and entry positions in queue */
int       count = 0;     /* count of items in queue */

void  get_data( CUSTOMER *ptr ), put_data( const CUSTOMER *ptr );
CUSTOMER *insert( CUSTOMER cust ), *remov( void );

main()
{
     int   ans, flag;
     CUSTOMER cu, *ptr;

     /* do queue operations until user signals halt */
     do {
          do {
               printf( "\n\n\tEnter 1 to insert, 2 to remove:  " );
               scanf( "%d", &ans );
               printf( "\n" );
               switch ( ans ) {
               case 1: /* get a CUSTOMER and add to queue */
                    get_data( &cu );
                    if ( insert( cu ) == NULL )
                         printf( "\n\nQUEUE FULL\n\n" );
                    break;
               case 2: /* delete a CUSTOMER from queue and print */
                    if ( ( ptr = remov() ) != NULL )
                         put_data( ptr );
                    else
                         printf( "\n\nQUEUE EMPTY\n\n" );
                    break;
               default:
                    printf( "\nIllegal response\n" );
                    break;
               }
          } while ( ans != 1 && ans != 2 );
          printf( "\n\n\n1 to continue, 0 to quit: " );
          scanf( "%d", &flag );
          printf( "\n" );
     } while ( flag );

     return EXIT_SUCCESS;
}

/*   get_data prompts the user for a CUSTOMER's last name, first
     name, account_no, and balance stores the data at the address
     passed.                                                       */

void  get_data( CUSTOMER *ptr )
{
     printf( "\nenter the customer's last name: " );
     scanf( "%s", ptr -> lname );
     printf( "\nenter the customer's first name: " );
     scanf( "%s", ptr -> fname );
     printf( "\nenter the customer's account number: " );
     scanf( "%d", &( ptr -> account_no ) );
     printf( "\nenter the customer's balance: " );
     scanf( "%f", &( ptr -> balance ) );
     printf( "\n" );
}

/*   put_data writes the last name, first name, account_no, and
     balance of the CUSTOMER whose address is passed.              */

void put_data( const CUSTOMER *ptr )
{
     printf( "\ncustomer's name: %s, %s\n", ptr -> lname,
          ptr -> fname  );
     printf( "\ncustomer's account number: %d\n",
          ptr -> account_no );
     printf( "\ncustomer's balance: %f\n", ptr -> balance );
}

/*   If the queue is full, insert returns NULL. Otherwise, insert
     allocates storage for a CUSTOMER, copies the data passed into
     the allocated storage, adds the node to the rear (last node in
     the linked list), updates rear, NULLs the link field of the new
     node, updates count, and returns the address of the CUSTOMER
     added. */

CUSTOMER *insert( CUSTOMER cust )
{
     CUSTOMER *ptr;

     if ( count  >=  SIZE ) /* queue full? */
          return NULL;
     ptr = malloc( sizeof ( CUSTOMER ) ); /* new CUSTOMER */

     *ptr = cust; /* store data */

     if ( count == 0 ) /* empty queue? */
          front = ptr; /* front points to first node in list */
     else
          rear -> succ = ptr; /* if queue not empty, add at end */
     rear = ptr; /* update rear */
     ptr -> succ = NULL; /* NULL last succ field */
     ++count; /* update count */

     return ptr;
}

/*   If the queue is empty, remov returns NULL. Otherwise, remov
     copies the CUSTOMER at the front (first node in the linked list)
     to permanent storage, updates front, frees the node, updates
     count, and returns the address of the CUSTOMER.               */

CUSTOMER *remov( void )
{
     static CUSTOMER removed_cust;
     CUSTOMER *next;

     if ( count == 0 ) /* empty queue? */
          return NULL;
     removed_cust = *front; /* copy CUSTOMER at front */
     next = front; /* save front node's address for freeing */
     front = front -> succ; /* remove front node */
     free( next ); /* deallocate storage */
     --count; /* update count */

     return &removed_cust;
}
