/*   This program writes the standard input to the standard output,
     PAGE_LENGTH + 2 lines per page. (The extra two lines are for the
     page number and one blank line.) A page consists of

     Page     <page number>
     <blank>

     followed by up to PAGE_LENGTH lines of text.                  */

#include <stdio.h>
#include <stdlib.h>

#define TRUE 1
#define FALSE 0
#define PAGE_LENGTH 52

int print_page( void );
int echo_line( void );

main()
{
     /* print pages until standard input is exhausted */
     while ( print_page() )
          ;

     return EXIT_SUCCESS;
}

/*   If no input remains, print_page simply returns FALSE; otherwise,
     it prints a page number and a blank line followed by PAGE_LENGTH
     lines (or fewer if end-of-file is reached) and finally a form
     feed. If end-of-file was reached, print_page returns FALSE;
     otherwise, it returns TRUE.                                   */

int print_page( void )
{
     int line_no;
     int c;
     static int page_no = 1;

     if ( ( c = getchar() ) == EOF ) /* anything left? */
          return FALSE;

     /* Something was left. Put it back so echo_line works
        properly. */
     ungetc( c, stdin );
     printf( "Page     %d\n\n", page_no++ );

     for ( line_no = 0; line_no < PAGE_LENGTH; line_no++ )
          /* echo one line and check if end-of-file was reached */
          if ( echo_line() == EOF ) {
               putchar( '\f' );  /* form feed (jump to top of next
                                    page) */
               return FALSE;
          }

     putchar( '\f' );
     return TRUE;
}

/*   echo_line copies one line (defined as everything up to and
     including the next newline) from the standard input to the
     standard output. It returns EOF if end-of-file was reached and
     non-EOF ('\n' actually) if end-of-file was not reached.       */

int echo_line( void )
{
     int c;

     while ( ( c = getchar() ) != EOF && c != '\n' )
          putchar( c );

     if ( c == '\n' )
          putchar( '\n' );

     return c;
}
