#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <limits.h>

/* max is a macro defined in some systems */
#ifdef max
#undef max
#endif

int max( int how_many, ... );

main()
{
     int max_int;
     int i1, i2, i3, i4;  /* arguments to test max function */

     printf( "Enter one to four integers\n"
             "generate EOF when done\n" );

     scanf( "%d", &i1 );

     if ( scanf( "%d", &i2 ) == EOF )
          max_int = max( 1, i1 );
     else if ( scanf( "%d", &i3 ) == EOF )
          max_int = max( 2, i1, i2 );
     else if ( scanf( "%d", &i4 ) == EOF )
          max_int = max( 3, i1, i2, i3 );
     else
          max_int = max( 4, i1, i2, i3, i4 );

     printf( "\nMaximum integer = %d\n", max_int );

     return EXIT_SUCCESS;
}

/*   max -- Returns the maximum of a list of ints. The first argument
     is the number of ints over which to take the maximum. The ints
     over which to take the maximum follow the first argument.     */

int max( int how_many, ... )
{
     int largest = INT_MIN; /* low value so first comparison is
                               correct */
     int i;
     va_list arg_addr;  /* gives location of argument after how_many in
                           max */
     int next_int;

     va_start( arg_addr, how_many ); /* set arg_addr to the address
                                        of the first argument after
                                        how_many in max */

     for ( i = 0; i < how_many; i++ )
          /* va_arg returns the value of the next argument
             in max and updates arg_addr.  The second argument to va_arg
             is the data type of argument being read (in max). */
          if ( ( next_int = va_arg( arg_addr, int ) ) > largest )
               largest = next_int;

     va_end( arg_addr ); /* mop up */

     return largest;
}
