/* matrix multiplication program */

#include <stdio.h>
#include <stdlib.h>

#define MAXSIZE 20

void
  store( int m[ ][ MAXSIZE ], int n ),
  mult( int m1[ ][ MAXSIZE ], int m2[ ][ MAXSIZE ], 
        int m3[ ][ MAXSIZE ], int n ),
  print( int m[ ][ MAXSIZE ], int n );

main()
{
  int n;
  int m1[ MAXSIZE ][ MAXSIZE ], 
      m2[ MAXSIZE ][ MAXSIZE ],
      m3[ MAXSIZE ][ MAXSIZE ];

  /* read data into m1 and m2 and echo */
  printf( "Input matrix size: " );
  scanf( "%d", &n );
  printf( "Input first matrix by row\n" );
  store( m1, n );
  printf( "\nMatrix m1:\n" );
  print( m1, n );
  printf( "\nInput second matrix by row\n" );
  store( m2, n );
  printf( "\nMatrix m2:\n" );
  print( m2, n );

  /* multiply m1 by m2, storing product in m3 */
  mult( m1, m2, m3, n );

  /* print results */
  printf( "\nProduct m3:\n" );
  print( m3, n ); 

  return EXIT_SUCCESS;
}  

/* Multiply matrix m1 by matrix m2, storing the
 * product in matrix m3, where all three matrices are
 * n by n in size:
 *                  n-1
 *   m3[ i ][ j ] = SUM m1[ i ][ k ] * m2[ k ][ j ] 
 *                  k=0
 * and 0 <= i,j < n.
 */
void mult( int m1[ ][ MAXSIZE ], 
           int m2[ ][ MAXSIZE ], 
           int m3[ ][ MAXSIZE ], 
           int n )
{
  int i, j, k;

  for ( i = 0; i < n; i++ ) 
    for ( j = 0; j < n; j++ ) {
      m3[ i ][ j ] = 0;
      for ( k = 0; k < n; k++ ) 
        m3[ i ][ j ] += m1[ i ][ k ] * m2[ k ][ j ];
    }
}

/* Store data in matrix by row.
 */
void store( int m[ ][ MAXSIZE ], int n )
{
  int i, j;

  for ( i = 0; i < n; i++ )
    for ( j = 0; j < n; j++ )
      scanf( "%d", &m[ i ][ j ] );
}

void print( int m[ ][ MAXSIZE ], int n )
{
  int i, j;

  for ( i = 0; i < n; i++ ) {
    for ( j = 0; j < n; j++ )
      printf( "%d ", m[ i ][ j ] );
    putchar( '\n' );
  }
}