#include <stdlib.h>
#include <conc.h>

#define SIZE 500

void selectsort( int *a, int size );
void swap( int *p, int *q );

main()
{
     int a[ SIZE ], size, *ptr;
     Channel *in, *out;

     /* assign Channel pointers to physical channels */
     out = LINK1OUT;
     in = LINK1IN;

     /* get number of values to receive from host */
     size = ChanInInt( in );

     /* get values to sort from host */
     ChanIn( in, a, sizeof ( int ) * size );

     /* sort values received from host */
     selectsort( a, size );

     /* send values in sorted order to host */
     for ( ptr = a; ptr < a + size; ptr++ )
          ChanOutInt( out, *ptr );
}

void selectsort( int *a, int size )
{
     int *end, *p, *small;

     end = a + size;

     for ( ; a < end - 1; a++ ) {
          small = a;
          for ( p = a + 1; p < end; p++ )
               if ( *p < *small )
                    small = p;
          if ( a != small )
               swap( a, small );
     }
}

void swap( int *p, int *q )
{
     int temp;

     temp = *p;
     *p = *q;
     *q = temp;
}
