/*  This program is a modification of the program in the file   */
/*  cars1.c which is discussed in Section 5.3.  Here a separate */
/*  function print_report is used to generate the report on     */
/*  inventory and daily sales.                                  */

#include <stdio.h>
#include <stdlib.h>

#define NUM_BRANDS 12 /* number of car brands currently handled */

void print_report( int inventory[], int sales[] );

main()
{
       int  cars_in_stock[ NUM_BRANDS ];
       int  total_cars_sold[ NUM_BRANDS ];
       int  cars_sold;
       int  brand;

       /* Initialize cars_in_stock and total_cars_sold for each
          brand. */
       for ( brand = 0; brand < NUM_BRANDS; ++brand ) {
          printf( "\n\n\tCars in stock for brand: %d  ", brand );
          scanf( "%d", &cars_in_stock[ brand ] );
          total_cars_sold[ brand ] = 0;
       }
       /* Record sales, updating total_cars_sold, until user
          signals halt.*/
       printf( "\n\n\n" );

       /* Loop until user signals halt by setting brand less than
          zero. */
        while ( brand >= 0 ) {
            printf( "\n\n\t Which brand was sold? " );
            scanf( "%d", &brand );
            /* BRAND in bounds? */
            if ( brand >= 0 && brand < NUM_BRANDS ) {
                 printf( "\n\t How many cars in sale? " );
                 scanf( "%d", &cars_sold );
                 total_cars_sold[ brand ] += cars_sold;
            }
       }

       /* Generate daily report for each brand. */
       print_report( cars_in_stock, total_cars_sold );

       return EXIT_SUCCESS;
}

void print_report( int inventory[], int sales[] )
{
       int brand;

       printf( "\n\n\n\n\t\tDAILY REPORT" );
       printf( "\n\t\t----- ------" );

       for ( brand = 0; brand < NUM_BRANDS; ++brand ) {
          printf( "\n\n\t\tBrand #:\t\t\t%d", brand );
          printf( "\n\t\tInventory at day's start:\t%d",
              inventory[ brand ] );
          printf( "\n\t\tTotal sales:\t\t\t%d",
              sales[ brand ] );
          printf( "\n\t\tInventory at day's end:\t\t%d",
              inventory[ brand ] - sales[ brand ] );
          printf( "\n\t\tSales as percentage of inventory:\t\t%f",
               100 * ( (float) sales[ brand ] /
               ( float ) inventory[ brand ] ) );
       }
}
