/*   This program prints a calendar for a year. The user enters a
     code for the day of week for Jan 1 to begin and a code to
     indicate whether or not the calendar is to be a leap year
     calendar.

     The codes are: day_code (0 = Sun, 1 = Mon, etc.)
                    leap_year (0 = no leap year, 1 = leap year)   */

#include <stdio.h>

main()
{
     int day_code, /* day_code = 0 means the month starts on Sun
                      day_code = 1 means the month starts on Mon
                      day_code = 2 means the month starts on
                                                       Tues, etc.  */
         days_in_month,     /* number of days in month currently 
                                                     being printed */
         leap_year, /* 1 means leap year; 0 means no leap year */
         day,       /* counter for day of month */
         month;     /* month = 1 is Jan, month = 2 is Feb, etc. */

     do {
          printf( "Enter day and leap year codes: " );
          scanf( "%d%d", &day_code, &leap_year );
     } while ( day_code < 0 || day_code > 6 );

     for ( month = 1; month <= 12; month++ ) {
          switch ( month ) { /* print name and set days_in_month */
          case 1:
               printf( "\n\nJanuary" );
               days_in_month = 31;
               break;
          case 2:
               printf( "\n\nFebruary" );
               days_in_month = leap_year ? 29 : 28;
               break;
          case 3:
               printf( "\n\nMarch" );
               days_in_month = 31;
               break;
          case 4:
               printf( "\n\nApril" );
               days_in_month = 30;
               break;
          case 5:
               printf( "\n\nMay" );
               days_in_month = 31;
               break;
          case 6:
               printf( "\n\nJune" );
               days_in_month = 30;
               break;
          case 7:
               printf( "\n\nJuly" );
               days_in_month = 31;
               break;
          case 8:
               printf( "\n\nAugust" );
               days_in_month = 31;
               break;
          case 9:
               printf( "\n\nSeptember" );
               days_in_month = 30;
               break;
          case 10:
               printf( "\n\nOctober" );
               days_in_month = 31;
               break;
          case 11:
               printf( "\n\nNovember" );
               days_in_month = 30;
               break;
          case 12:
               printf( "\n\nDecember" );
               days_in_month = 31;
               break;
          }

          printf( "\n\nSun  Mon  Tue  Wed  Thu  Fri  Sat\n" );

          /* advance printer to correct position for first date */
          for ( day = 1; day <= 1 + day_code * 5; day++ )
               printf( " " );

          /* print the dates for one month */
          for ( day = 1; day <= days_in_month; day++ ) {
               printf( "%2d", day );
               if ( ( day + day_code ) % 7 > 0 ) /* before Sat? */
                    /* move to next day in same week */
                    printf( "   " );
               else  /* skip to next line to start with Sun */
                    printf( "\n " );
          }

          /* set day_code for next month to begin */
          day_code = ( day_code + days_in_month ) % 7;
     }
}
