#include <stdio.h>
#include <stdlib.h>

typedef  enum seven_deadly_sins { anger, lust, envy, gluttony,
                                  pride, sloth, covetousness }
SINS;

#define  START   anger   /* start vertex */
#define  SIZE    7       /* number of vertices */

typedef  struct node {         /* NODE for adjacency lists */
         SINS           sin;
         struct node    *link;
} NODE;

NODE *graph[ SIZE ];   /* array of pointers to adjacency lists */
int visited[ SIZE ];   /* 1 means visited; 0 means not visited */
SINS sin_queue[ SIZE ];

/* queue indexes and counter */
int  front = 0, rear = 0, count = 0;

void initialize( void ), bfs2( SINS next );
void insert( SINS item ), visit( SINS sin );
SINS delete( void );

main()
{

     initialize();
     bfs2( START );

     return EXIT_SUCCESS;
}

/* The function initialize constructs the adjacency lists */

void  initialize( void )
{
     int i;
     NODE *ptr;

     for ( i = 0; i < SIZE; i++ )
          graph[ i ] = NULL;

               /* initialize sins */

     /* (anger, lust) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ anger ];
     graph[ anger ] = ptr;
     ptr -> sin = lust;

     /* (anger, envy) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ anger ];
     graph[ anger ] = ptr;
     ptr -> sin = envy;

     /* (anger, gluttony) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ anger ];
     graph[ anger ] = ptr;
     ptr -> sin = gluttony;

     /* (lust, anger) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ lust ];
     graph[ lust ] = ptr;
     ptr -> sin = anger;

     /* (lust, envy) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ lust ];
     graph[ lust ] = ptr;
     ptr -> sin = envy;

     /* (envy, anger) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ envy ];
     graph[ envy ] = ptr;
     ptr -> sin = anger;

     /* (envy, lust) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ envy ];
     graph[ envy ] = ptr;
     ptr -> sin = lust;

     /* (envy, pride) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ envy ];
     graph[ envy ] = ptr;
     ptr -> sin = pride;

     /* (envy, sloth) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ envy ];
     graph[ envy ] = ptr;
     ptr -> sin = sloth;

     /* (gluttony, anger) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ gluttony ];
     graph[ gluttony ] = ptr;
     ptr -> sin = anger;

     /* (gluttony, sloth) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ gluttony ];
     graph[ gluttony ] = ptr;
     ptr -> sin = sloth;

     /* (pride, envy) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ pride ];
     graph[ pride ] = ptr;
     ptr -> sin = envy;

     /* (sloth, envy) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ sloth ];
     graph[ sloth ] = ptr;
     ptr -> sin = envy;

     /* (sloth, gluttony) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ sloth ];
     graph[ sloth ] = ptr;
     ptr -> sin = gluttony;

     /* (sloth, covetousness) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ sloth ];
     graph[ sloth ] = ptr;
     ptr -> sin = covetousness;

     /* (covetousness, sloth) */
     ptr = malloc( sizeof ( NODE ) );
     ptr -> link = graph[ covetousness ];
     graph[ covetousness ] = ptr;
     ptr -> sin = sloth;
}

/*   The  function  bfs2  does a breadth-first search beginning at the
     vertex next.                                                  */

void  bfs2( SINS next )
{
     NODE *ptr;

     /* Put next in queue and mark it as visited. */
     insert( next );
     visit( next );
     visited[ next ] = 1;

     /* Search until queue is empty. */
     /* next < 0 means empty queue. */
     while ( ( next = delete() ) >= 0 ) {
          ptr = graph[ next ];
          /* Queue up unvisited adjacent vertices. */
          while ( ptr != NULL ) {
               next = ptr -> sin;
               if ( !visited[ next ] ) {
                    /* Put next in queue and mark it as visited. */
                    insert( next );
                    visit( next );
                    visited[ next ] = 1;
               }
               ptr = ptr -> link;
          }
     }
}

/* Print a visit message. */
void  visit( SINS sin )
{
     switch( sin ) {
     case anger:
          printf( "\n\nAnger has been visited.\n\n" );
          break;
     case lust:
          printf( "\n\nLust has been visited.\n\n" );
          break;
     case envy:
          printf( "\n\nEnvy has been visited.\n\n" );
          break;
     case gluttony:
          printf( "\n\nGluttony has been visited.\n\n" );
          break;
     case pride:
          printf( "\n\nPride has been visited.\n\n" );
          break;
     case sloth:
          printf( "\n\nSloth has been visited.\n\n" );
          break;
     case covetousness:
          printf( "\n\nCovetousness has been visited.\n\n" );
          break;
     }
}

/* Insert item in queue. */
void insert( SINS item )
{
     if ( count == SIZE )
          printf( "\n\nFULL QUEUE\n\n" );
     else {
          sin_queue[ rear ] = item;
          rear = ++rear % SIZE;
          ++count;
     }
}

/* Delete an item from queue and return it. */
/* If queue is empty, return -1. */
SINS delete( void )
{
     SINS front_value;

     if ( count == 0 )
          return -1;
     front_value = sin_queue[ front ];
     front = ++front % SIZE;
     --count;

     return front_value;
}
