#include <iostream.h>
#include <stdlib.h>  
#include <string.h>
                 
const int MaxName = 20;
                 
class SShip {            // space ship
  float mass;            // kilograms
  float vel;             // kilometers per hour  
  float dist;            // trip distance in kilometers
  int   cap;             // number of astronauts
  char  name[ MaxName ]; 
public:  
  SShip(); 
  SShip( float Mass, float Vel, float Dist, 
         int Cap, char* Name );
  void adjustVel( float adj );
  void printBasics();
  float getMass();
  float getVel();
  float getDist();  
  int getCap();           
  char* getName();
};

// default constructor: invoked whenever a SShip object
// is created with no initial values for data members
SShip::SShip()
{
  mass = vel = dist = 0.0F;          
  cap = 0;
  strcpy( name, "???" );
}   

// parameterized constructor: invoked whenever a SShip
// object is created with initial values for data members
SShip::SShip( float Mass, float Vel, float Dist,
              int Cap, char* Name )
{
  mass = Mass;
  vel = Vel;     
  cap = Cap;  
  dist = Dist;
  strncpy( name, Name, MaxName - 1 );
} 

// adjust a SShip's velocity
void SShip::adjustVel( float Diff )
{
  vel += Diff;
  if ( vel < 0.0F )
    vel = 0.0F;
}
         
// print all data members     
void SShip::printBasics()
{
  cout << '\n' << name << " has a mass of " 
       << mass << "\nand a velocity of "
       << vel << " and holds " 
       << cap << " astronauts " 
       << "for a trip of " << dist 
       << " kilometers." << endl;
} 

char* SShip::getName()
{
  return name;
}             

float SShip::getVel()
{
  return vel;
}

float SShip::getMass()
{
  return mass;
}                 

float SShip::getDist()
{
  return dist;
}      

int SShip::getCap()
{
  return cap;
}
                   
main()
{
  // create a ship object with no initial values
  // default constructor therefore invoked
  SShip s1; 

  // create a ship object with initial values
  SShip s2( 5000, 63567, 560989, 4, "MightyMite" );

  s1.printBasics();      // s1's printBasics method       
  s2.printBasics();      // s2's printBasics method
  s2.adjustVel( 2000 );  // s2's adjustVel method
  s2.adjustVel( -1000 ); // ditto
  s2.printBasics();      // s2's printBasics method 
  
  // use methods to compute time required for trip
  cout << "\n" << s2.getName() << " requires " 
       << s2.getDist() / s2.getVel() 
       << " hours for trip." << endl;

  return EXIT_SUCCESS;
}

