/* Macros for complex arithmetic and for
   input/output of complex numbers.
*/

struct complex {
   double real;
   double imag;
};

static double _abs_sq;

/* c = a + b */
#define add_c( c, a, b ) ( \
   c.real = a.real + b.real, \
   c.imag = a.imag + b.imag )

/* c = a - b */
#define sub_c( c, a, b ) ( \
   c.real = a.real - b.real, \
   c.imag = a.imag - b.imag )

/* c = a * b */
#define mul_c( c, a, b ) ( \
   c.real = a.real * b.real - a.imag * b.imag, \
   c.imag = a.imag * b.real + a.real * b.imag )

/* c = a / b */
#define div_c( c, a, b ) ( \
   _abs_sq = b.real * b.real + b.imag * b.imag, \
   c.real = ( a.real * b.real + a.imag * b.imag ) / _abs_sq, \
   c.imag = ( a.imag * b.real - a.real * b.imag ) / _abs_sq )

/* read a complex number from stdin */
#define read_c( c ) scanf( "%lf%lf", &c.real, &c.imag )

/* write a complex number to stdout */
#define print_c( c ) \
   printf( "%f + %fI", c.real, c.imag )
