import java.awt.*;
import java.util.*;


public class WebClient extends QuittableFrame implements Runnable, Interruptable {
  public static void main(String[] args) {
    WebClient wc = new WebClient("Web Client");
    wc.resize(600, 700);
    wc.show();
  }

  private LabeledTextField hostField, portField, requestLineField;
  private TextArea requestHeadersArea, resultArea;
  private String host, requestLine;
  private int port;
  private String[] requestHeaders = new String[30];
  private Button submitButton, interruptButton;
  private boolean interrupted = false;

  public WebClient(String title) {
    super(title);
    setBackground(Color.lightGray);
    setLayout(new BorderLayout(5, 30));
    int fontSize = 14;
    Font labelFont =
      new Font("TimesRoman", Font.BOLD, fontSize);
    Font headingFont =
      new Font("Helvetica", Font.BOLD, fontSize+4);
    Font textFont =
      new Font("Courier", Font.BOLD, fontSize-2);
    Panel inputPanel = new Panel();
    inputPanel.setLayout(new BorderLayout());
    Panel labelPanel = new Panel();
    labelPanel.setLayout(new GridLayout(4,1));
    hostField = new LabeledTextField("Host:", labelFont,
                                     "www.internic.com", 30, textFont);
    portField = new LabeledTextField("Port:", labelFont,
                                     "80", 5, textFont);
    requestLineField = new LabeledTextField("Request Line:",
                                            labelFont,
                                            "POST /cgi-bin/nwhois HTTP/1.0",
                                            50,
                                            textFont);
    labelPanel.add(hostField);
    labelPanel.add(portField);
    labelPanel.add(requestLineField);
    Label requestHeadersLabel = new Label("Request Headers:");
    requestHeadersLabel.setFont(labelFont);
    labelPanel.add(requestHeadersLabel);
    inputPanel.add("North", labelPanel);
    requestHeadersArea = new TextArea(5, 80);
    requestHeadersArea.setFont(textFont);

    String req = "Content-Length: ";
    String domain = "cyber";
    String root = "com";
    String query = "domain=" + domain + "&root=" + root;
    req += query.length() + "\n\n" + query;
    requestHeadersArea.setText(req);

    inputPanel.add("Center", requestHeadersArea);
    Panel buttonPanel = new Panel();
    submitButton = new Button("Submit Request");
    submitButton.setFont(labelFont);
    buttonPanel.add(submitButton);
    inputPanel.add("South", buttonPanel);
    add("North", inputPanel);
    Panel resultPanel = new Panel();
    resultPanel.setLayout(new BorderLayout());
    Label resultLabel = new Label("Results", Label.CENTER);
    resultLabel.setFont(headingFont);
    resultPanel.add("North", resultLabel);
    resultArea = new TextArea();
    resultArea.setFont(textFont);
    resultPanel.add("Center", resultArea);
    Panel interruptPanel = new Panel();
    interruptButton = new Button("Interrupt Download");
    interruptButton.setFont(labelFont);
    interruptPanel.add(interruptButton);
    resultPanel.add("South", interruptPanel);
    add("Center", resultPanel);
  }

  public boolean action(Event event, Object object) {
    if (event.target == submitButton) {
      Thread downloader = new Thread(this);
      downloader.start();
      return(true);
    } else if (event.target == interruptButton) {
      interrupted = true;
      return(true);
    } else
      return(false);
  }

  public void run() {
    interrupted = false;
    if (checkArgs()) {
      HttpClient client = new HttpClient(host,
                                         port, 
                                         requestLine,
                                         requestHeaders,
                                         resultArea,
                                         this);
    }
  }

  public boolean interrupted() {
    return(interrupted);
  }

  private boolean checkArgs() {
    host = hostField.getTextField().getText();
    if (host.length() == 0) {
      report("Missing hostname");
      return(false);
    }
    String portString = portField.getTextField().getText();
    if (portString.length() == 0) {
      report("Missing port number");
      return(false);
    }
    try {
      port = Integer.parseInt(portString);
    } catch(NumberFormatException nfe) {
      report("Illegal port number: " + portString);
      return(false);
    }
    requestLine = requestLineField.getTextField().getText();
    if (requestLine.length() == 0) {
      report("Missing request line");
      return(false);
    }
    getRequestHeaders();
    return(true);
  }

  private void report(String s) {
    resultArea.setText(s);
  }

  private void getRequestHeaders() {
    for(int i=0; i<requestHeaders.length; i++)
      requestHeaders[i] = null;
    int headerNum = 0;
    String header = requestHeadersArea.getText();
    StringTokenizer tok = new StringTokenizer(header, "\r\n");
    while (tok.hasMoreTokens()) {
      String line = tok.nextToken();
      requestHeaders[headerNum++] = line;
      // to keep the empty line for the purpose of post
      if (line.startsWith("Content-Length:")) {
          requestHeaders[headerNum++] = "";
      }
    }
  }
}
