import java.net.*;  
import java.io.*;


public class NetworkClient {
  protected String host;
  protected int port;

  public NetworkClient(String host, int port) {
    this.host = host;
    this.port = port;
  }

  public void connect() {
    try {
      Socket client = new Socket(host, port);
      handleConnection(client);
    } catch(UnknownHostException uhe) {
      System.out.println("Unknown host: " + host);
      uhe.printStackTrace();
    } catch(IOException ioe) {
      System.out.println("IOException: " + ioe);
      ioe.printStackTrace();
    }
  }

  protected void handleConnection(Socket client)
      throws IOException {
    SocketUtil s = new SocketUtil(client);
    PrintStream out = s.getPrintStream();
    DataInputStream in = s.getDataStream();
    out.println("Generic Network Client");
    System.out.println
      ("Generic Network Client:\n" +
       "Made connection to " + host +
       " and got '" + in.readLine() + "' in response");
    client.close();
  }

  public String getHost() {
    return(host);
  }

  public int getPort() {
    return(port);
  }
}
