import java.awt.*;


public class LabeledTextField extends Panel {
  private Label label;
  private TextField textField;
  
  public LabeledTextField(String labelString,
                          Font labelFont,
                          int textFieldSize,
                          Font textFont) {
    setLayout(new FlowLayout(FlowLayout.LEFT));
    label = new Label(labelString, Label.RIGHT);
    if (labelFont != null)
      label.setFont(labelFont);
    add(label);
    textField = new TextField(textFieldSize);
    if (textFont != null)
      textField.setFont(textFont);
    add(textField);
  }

  public LabeledTextField(String labelString,
                          String textFieldString) {
    this(labelString, null, textFieldString,
         textFieldString.length(), null);
  }

  public LabeledTextField(String labelString,
                          int textFieldSize) {
    this(labelString, null, textFieldSize, null);
  }
  
  public LabeledTextField(String labelString,
                          Font labelFont,
                          String textFieldString,
                          int textFieldSize,
                          Font textFont) {
    this(labelString, labelFont,
         textFieldSize, textFont);
    textField.setText(textFieldString);
  }

  public Label getLabel() {
    return(label);
  }

  public TextField getTextField() {
    return(textField);
  }
}
