import java.awt.*;
import java.net.*;
import java.io.*;


public class HttpClient extends NetworkClient {
  private String requestLine;
  private String[] requestHeaders;
  private TextArea outputArea;
  private Interruptable app;
  
  public HttpClient(String host,
                    int port,
                    String requestLine,
                    String[] requestHeaders,
                    TextArea outputArea,
                    Interruptable app) {
    super(host, port);
    this.requestLine = requestLine;
    this.requestHeaders = requestHeaders;
    this.outputArea = outputArea;
    this.app = app;
    if (checkHost(host))
      connect();
  }

  protected void handleConnection(Socket uriSocket)
      throws IOException {
    try {
      SocketUtil s = new SocketUtil(uriSocket);
      PrintStream out = s.getPrintStream();
      DataInputStream in = s.getDataStream();
      outputArea.setText("");
      out.println(requestLine);
      for(int i=0; i<requestHeaders.length; i++) {
        if (requestHeaders[i] == null) {
          break;
        } else {
          out.println(requestHeaders[i]);
        }
      }
      out.println();
      String line;
      while ((line = in.readLine()) != null &&
             !app.interrupted()) {
        outputArea.appendText(line + "\n");
      }
      if (app.interrupted()) {
        outputArea.appendText("---- Download Interrupted ----");
      }
    } catch(Exception e) {
      outputArea.setText("Error: " + e);
    }
  }

  private boolean checkHost(String host) {
    try {
      InetAddress.getByName(host);
      return(true);
    } catch(UnknownHostException uhe) {
      outputArea.setText("Bogus host: " + host);
      return(false);
    }
  }
}
