import java.awt.*;


public class VLISTM extends Frame {
    java.awt.Label label1;
    java.awt.Label label2;
    java.awt.Label label3;
    java.awt.TextField textField1;
    java.awt.TextField textField2;
    
    // Used for addNotify check.
    boolean fComponentsAdjusted = false;

    // application specific variables
    private UserDatabase users;
    
    public VLISTM(String title) {
        setLayout(null);
        setVisible(false);
        setSize(405,210);
        setBackground(new Color(65280));
        label1 = new java.awt.Label("Welcome to VLIST Mailer",Label.CENTER);
        label1.setBounds(43,28,320,43);
        label1.setFont(new Font("Dialog", Font.PLAIN, 20));
        label1.setForeground(new Color(16711680));
        add(label1);
        label2 = new java.awt.Label("Login: ",Label.RIGHT);
        label2.setBounds(65,89,102,29);
        label2.setFont(new Font("Dialog", Font.PLAIN, 16));
        label2.setForeground(new Color(255));
        add(label2);
        label3 = new java.awt.Label("Password:  ",Label.RIGHT);
        label3.setBounds(65,127,102,29);
        label3.setFont(new Font("Dialog", Font.PLAIN, 16));
        label3.setForeground(new Color(255));
        add(label3);
        textField1 = new java.awt.TextField();
        textField1.setBounds(186,89,153,29);
        textField1.setFont(new Font("Dialog", Font.PLAIN, 16));
        textField1.setBackground(new Color(16777215));
        add(textField1);
        textField2 = new java.awt.TextField();
        textField2.setEchoChar('*');
        textField2.setBounds(186,127,153,29);
        textField2.setFont(new Font("Dialog", Font.PLAIN, 16));
        textField2.setBackground(new Color(16777215));
        add(textField2);
        setTitle(title);

        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        textField1.addActionListener(lSymAction);
        textField2.addActionListener(lSymAction);
        
        // get user info
        users = new UserDatabase();
    }
    
    public VLISTM()  {
        this("VLIST Mailer");
    }
    
    static public void main(String args[]) {
        (new VLISTM()).setVisible(true);
    }
    
    public void addNotify() {
        // Record the size of the window prior to calling parents addNotify.
        Dimension d = getSize();
        
        super.addNotify();
    
        if (fComponentsAdjusted) return;
    
        // Adjust components according to the insets
        setSize(insets().left + insets().right + d.width, insets().top + insets().bottom + d.height);
        Component components[] = getComponents();
        for (int i = 0; i < components.length; i++) {
            Point p = components[i].getLocation();
            p.translate(insets().left, insets().top);
            components[i].setLocation(p);
        }
        fComponentsAdjusted = true;
    }
    
    public void setVisible(boolean b) {
        if(b) {
            setLocation(50, 50);
        }   
        super.setVisible(b);
    }
    
    class SymWindow extends java.awt.event.WindowAdapter {
        public void windowClosing(java.awt.event.WindowEvent event) {
            Object object = event.getSource();
            if (object == VLISTM.this) {
                VLISTM_WindowClosing(event);
            }
        }
    }
    
    void VLISTM_WindowClosing(java.awt.event.WindowEvent event) {
        setVisible(false);  // hide the Frame
        dispose();          // free the system resources
        System.exit(0);     // close the application
    }
    
    class SymAction implements java.awt.event.ActionListener {
        public void actionPerformed(java.awt.event.ActionEvent event) {
            Object object = event.getSource();
            if (object == textField1 || object == textField2) {
                textField_EnterHit(event);
            }
        }
    }
    
    void textField_EnterHit(java.awt.event.ActionEvent event) {
        String usernameInput = textField1.getText();
        String passwordInput = textField2.getText();
        int userIndex = users.matchUser(usernameInput, passwordInput);
        
        if (userIndex == -1) return;
        if (users.getLevel(userIndex) == PriviledgeLevel.PL_GUEST) return;
        if (users.getEmail(userIndex).equals("")) return;
        
        textField2.setText("");
        (new MailerDialog(this, true, users, userIndex)).setVisible(true);
    }
}
