import java.io.*;
import java.net.*;
import java.util.*;


public class UserDatabase {
    private static final String URL_FILE = "http://shrike.depaul.edu/~szhou1/projects/tdc513/98765432.txt";
    private static final char USERNAME_DELIM   = '~';
    private static final char PASSWORD_DELIM   = '*';
    private static final char NAME_DELIM       = '^';
    private static final char PRIVILEDGE_DELIM = '#';
    private static final char EMAIL_DELIM      = '\"';
    private Vector users = new Vector();

    public UserDatabase () {
        try {
            URL url = new URL(URL_FILE);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line;
            while ((line = in.readLine()) != null) {
                //System.out.println(line);
                int usernameB = line.indexOf(USERNAME_DELIM);
                int usernameE = line.indexOf(USERNAME_DELIM, usernameB + 1);
                int passwordB = line.indexOf(PASSWORD_DELIM);
                int passwordE = line.indexOf(PASSWORD_DELIM, passwordB + 1);
                int nameB     = line.indexOf(NAME_DELIM);
                int nameE     = line.indexOf(NAME_DELIM, nameB + 1);
                int levelB    = line.indexOf(PRIVILEDGE_DELIM);
                int levelE    = line.indexOf(PRIVILEDGE_DELIM, levelB + 1);
                int emailB    = line.indexOf(EMAIL_DELIM);
                int emailE    = line.indexOf(EMAIL_DELIM, emailB + 1);
                if ((usernameB != -1) && (usernameE != -1) &&
                    (passwordB != -1) && (passwordE != -1) &&
                    (nameB != -1) && (nameE != -1) &&
                    (levelB != -1) && (levelE != -1) &&
                    (emailB != -1) && (emailE != -1)) {
                    UserRecord user = new UserRecord(
                            line.substring(usernameB + 1, usernameE),
                            line.substring(passwordB + 1, passwordE),
                            line.substring(nameB + 1, nameE),
                            Integer.parseInt(line.substring(levelB + 1, levelE)),
                            line.substring(emailB + 1, emailE));
                    users.addElement(user);
                }
            }
        } catch (Exception e) {
            users.addElement(new UserRecord("", "", e.toString(), 0, ""));
        }
    }

    public int matchUser(String username, String password) {
        for (int i = 0; i < users.size(); i++) {
            UserRecord user = (UserRecord)users.elementAt(i);
            if (user.match(username, password)) return i;
        }
        return -1;
    }

    public String getName(int i) {
        if (i < users.size()) {
            return ((UserRecord)users.elementAt(i)).getName();
        } else {
            return null;
        }
    }

    public int getLevel(int i) {
        if (i < users.size()) {
            return ((UserRecord)users.elementAt(i)).getLevel();
        } else {
            return PriviledgeLevel.PL_NONE;
        }
    }

    public String getEmail(int i) {
        if (i < users.size()) {
            return ((UserRecord)users.elementAt(i)).getEmail();
        } else {
            return null;
        }
    }
    public int size() {
        return users.size();
    }

    public String toString() {
        if (users.size() == 0) return null;
        String info = "";
        for (int i = 0; i < users.size(); i++) {
            info += "Record " + (i + 1) + ": "
                 + (UserRecord)users.elementAt(i) + "\n";
        }
        return info;
    }
}

class UserRecord implements Serializable {
    private String username;
    private String password;
    private String name;
    private int level;
    private String email;

    public UserRecord(String username, String password, String name, int level, String email) {
        this.username = username;
        this.password = password;
        this.name     = name;
        this.level    = level;
        this.email    = email;
    }

    public boolean match(String username, String password) {
        return (this.username.compareTo(username) == 0) &&
               (this.password.compareTo(password) == 0);
    }

    public String getName() {
        return name;
    }

    public int getLevel() {
        return level;
    }

    public String getEmail() {
        return email;
    }

    public String toString() {
        return ("\t" + username + "\t" + password + "\t" + name + "\t" + level);
    }
}
